package com.xforceplus.elephant.image.controller.image.process.insertimage;

import static com.xforceplus.elephant.image.core.business.consts.Constants.TENANT_CODE;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.annotation.Dispatch;
import com.xforceplus.elephant.basecommon.baseconst.ReleationConstants;
import com.xforceplus.elephant.basecommon.dispatch.BeanDispatcher;
import com.xforceplus.elephant.basecommon.enums.EntityConstant;
import com.xforceplus.elephant.basecommon.enums.common.WebsocketNoticeTypeEnum;
import com.xforceplus.elephant.basecommon.exception.ElephantException;
import com.xforceplus.elephant.basecommon.help.BeanUtils;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.ImageInsertDTO;
import com.xforceplus.elephant.image.client.model.InsertImageRequest;
import com.xforceplus.elephant.image.core.business.application.collect.batch.domain.EnableFlowContext;
import com.xforceplus.elephant.image.core.business.application.collect.batch.service.BatchService;
import com.xforceplus.elephant.image.core.business.config.queue.MQUtils;
import com.xforceplus.elephant.image.core.business.enums.MQEnum;
import com.xforceplus.elephant.image.core.business.util.LogUtil;
import com.xforceplus.elephant.image.core.domain.bill.BaseBillService;
import com.xforceplus.elephant.image.core.domain.config.ConfigSettingsService;
import com.xforceplus.elephant.image.core.domain.image.ImageService;
import com.xforceplus.elephant.image.core.expand.BillImageTicketService;
import com.xforceplus.elephant.image.core.expand.bean.TicketRecogBean;
import com.xforceplus.elephant.image.core.repository.model.BatchTaskEntity;
import com.xforceplus.elephant.image.core.util.RequestBuilder;
import com.xforceplus.purchaser.bizratelimiter.model.Application;
import com.xforceplus.purchaser.bizratelimiter.model.BizRequest;
import com.xforceplus.purchaser.bizratelimiter.model.Channel;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BackType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BillDataStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.ExceptionStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.ImageStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.ImageType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.RecStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.YesNo;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BaseBill;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionOp;
import com.xforceplus.xlog.core.model.LogContext;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.groovy.util.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Dispatch(tenantCode = "CQP")
@Service
public class CQPInsertImageProcess extends DefaultInsertImageProcess {

    @Autowired
    private ImageService imageService;
    @Autowired
    private BaseBillService baseBillService;
    @Autowired
    private BillImageTicketService billImageTicketService;
    @Autowired
    private MQUtils rabbitmqUtils;
    @Autowired
    private BeanDispatcher beanDispatcher;
    @Autowired
    private ConfigSettingsService configSettingsService;
    @Autowired
    private BatchService batchService;
    @Autowired(required = false)
    private Application application;

    @Override
    protected void check(InsertImageRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getBillCode(), "单据CODE不能为空");
        checkEmpty(request.getEntities(), "操作对象不能为空");
        for (ImageInsertDTO entity : request.getEntities()) {
            checkEmpty(entity.getBatchNo(), "扫描批次号不能为空");
            checkEmpty(entity.getImageCategory(), "影像目录不能为空");
            checkEmpty(entity.getImageSource(), "来源不能为空");
            checkEmpty(entity.getFileUrl(), "原始文件路径不能为空");
            checkEmpty(entity.getFileUrlHandle(), "处理文件路径不能为空");
            checkEmpty(entity.getFileType(), "原始文件类型不能为空");
            checkEmpty(entity.getFileTypeHandle(), "处理文件类型不能为空");
            checkEmpty(entity.getIsPublic(), "是否公共上传不能为空");
        }
    }

    @Override
    protected CommonResponse<List<Long>> process(InsertImageRequest request) throws RuntimeException {
        final IAuthorizedUser user = UserInfoHolder.get();
        final BaseBill baseBill = baseBillService.selectBaseBillByCode(user.getTenantId(), request.getBillCode());
        checkEmpty(baseBill, "单据不存在");
        if (!Arrays.asList(BillDataStatus._0.getCode(), BillDataStatus._4.getCode()).contains(baseBill.getBillDataStatus())) {
            return CommonResponse.failed("单据非待提交或已退回状态不可补扫上传影像");
        }
        Image image = null;
        if (request.getParentImageId() != null && request.getParentImageId() > 0) {
            image = imageService.selectOne(user.getTenantId(), request.getParentImageId());
            if (ImageType._1.getCode().equals(image.getImageType())) {
                //多封面的时候，将挂接是在单据下的影像全部挂接在最后一张封面下
                final List<Image> imageEntities = imageService.selectCoversByBillCode(user.getTenantId(), request.getBillCode());
                image = imageEntities.get(imageEntities.size() - 1);
            }
        } else {
            image = imageService.getFileOrderByBillCode(user.getTenantId(), request.getBillCode());
        }
        final String batchNo = Long.toString(System.currentTimeMillis());
        final List<JSONObject> billImages = new ArrayList<>();
        final List<JSONObject> images = request.getEntities().stream().map(dto -> {
            final Image entity = Image.fromOQSMap(BeanUtils.convertJSON(dto));
            entity.setBatchNo(batchNo);
            entity.setTenantId(user.getTenantId());
            //补扫的单据全部变更为附件
            final boolean isCover = ValidatorUtil.isNotEmpty(entity.getBillCode());
            if (isCover) {
                entity.setImageType(ImageType._99.getCode());
                entity.setRequireOcrFlag(YesNo._0.getCode());
                entity.setRecStatus(RecStatus._2.getCode());
            } else {
                entity.setRequireOcrFlag(YesNo._1.getCode());
                entity.setRecStatus(RecStatus._0.getCode());
            }
            entity.setBillCode(request.getBillCode());
            entity.setBillEntityCode(baseBill.getBillTypeCode());
            entity.setStatus(ImageStatus._1.getCode());
            entity.setIsManualUnhook(YesNo._0.getCode());
            entity.setExceptionStatus(ExceptionStatus._0.getCode());
            entity.setReturnStatus(BackType._0.getCode());
            entity.setFileUrlLocal(StringUtils.EMPTY);
            entity.setCreateUserCode(user.getUserCode());
            entity.setCreateUserId(user.getId());
            entity.setCreateUserName(user.getUsername());
            entity.setCreateTime(LocalDateTime.now());
            entity.setOrgId(baseBill.getOrgId());
            entity.setOrgCode(baseBill.getOrgCode());
            entity.setOrgName(baseBill.getOrgName());
            final JSONObject json = new JSONObject(entity.toOQSMap());
            json.put(ReleationConstants.BILL_OTM_IMAGE_ID, baseBill.getId());
            if (isCover) {
                billImages.add(json);
            }
            return json;
        }).collect(Collectors.toList());
        final EnableFlowContext context = new EnableFlowContext().setTenantId(user.getTenantId()).setUserId(user.getId());
        final boolean flag = batchService.enable(context);
        LogContext.setLogPoint("enableFlow", flag);
        if (flag) {
            final String channelCode = batchService.getChannelCode(user.getTenantCode());
            final BatchTaskEntity batchTaskEntity = new BatchTaskEntity();
            batchTaskEntity.setTenantId(user.getTenantId());
            batchTaskEntity.setTenantCode(user.getTenantCode());
            batchTaskEntity.setCreateUserId(user.getId());
            batchTaskEntity.setCreateUserName(user.getUsername());
            batchTaskEntity.setCreateTime(new Date());
            batchTaskEntity.setTaskCount(request.getEntities().size());
            batchTaskEntity.setChannelCode(channelCode);
            final Long batchId = batchService.insert(batchTaskEntity);
            images.forEach(imageMap -> imageMap.put(EntityMeta.Image.BATCH_NO.code(), batchId));
            final Map<String, Object> headers = new HashMap<>();
            headers.put(com.xforceplus.elephant.image.core.business.consts.Constants.TENANT_CODE, user.getTenantCode());
            headers.put("batchNo", batchId);
            headers.put("userInfo", JSONObject.toJSONString(user));
            headers.put("channelCode", channelCode);
            headers.put("startTime", System.currentTimeMillis());
            final JSONObject message = new JSONObject();
            message.put("bill", baseBill);
            message.put("images", images);
            message.put("parentImage", image);
            try {
                if (batchService.sendEnableFlow(context)) {
                    final Channel channel = application.loadChannel(channelCode);
                    final BizRequest bizRequest = BizRequest.builder()
                                                            .bizQuantity(batchTaskEntity.getTaskCount())
                                                            .properties(headers)
                                                            .body(message.toJSONString())
                                                            .attrs(Maps.of("queueName", MQEnum.INSERT_BILL_SCAN_SYNC_QUEUE))
                                                            .build();
                    channel.flowInRateLimit(bizRequest);
                } else {
                    rabbitmqUtils.sendByDirectExchange(MQEnum.INSERT_BILL_SCAN_SYNC_QUEUE, message.toJSONString(), headers);
                }
            } catch (Exception e) {
                LogContext.setLogPoint("enableFlowError", e.getMessage());
                logger.error("使用限流异常", e);
                LogContext.setLogPoint("error", String.format("使用限流异常:%s", e.getMessage()));
                rabbitmqUtils.sendByDirectExchange(MQEnum.INSERT_BILL_SCAN_SYNC_QUEUE, message.toJSONString(), headers);
            } finally {
                LogUtil.attachSaveCount(CollectionUtils.size(request.getEntities()));
            }
            return CommonResponse.ok("成功");
        }
        final List<Long> imageIds;
        if (image == null) {
            imageIds = imageService.saveForMap(images);
        } else {
            imageIds = imageService.insertImagesForMap(image, images);
        }
        final RequestBuilder builder = new RequestBuilder()
            .field("tenant_id", ConditionOp.eq, user.getTenantId())
            .field("bill_code", ConditionOp.eq, baseBill.getBillCode());
        final JSONObject update = new JSONObject();
        update.put(ReleationConstants.BILL_OTM_IMAGE_ID, baseBill.getId());
        final int count = imageService.updateByCondition(builder, update);
        if (count == 0) {
            throw new ElephantException("更新影像所属单据失败");
        }
        if (ValidatorUtil.isNotEmpty(billImages)) {
            //创建附件
            toAnnex(billImages);
            //重算层级
            billImageTicketService.resetLevel(user.getTenantId(), request.getBillCode());
            //发送通知
            final JSONObject mqMessage = new JSONObject();
            mqMessage.put("noticeType", WebsocketNoticeTypeEnum.IMAGE_DISCERN.getCode());
            mqMessage.put("tenantId", user.getTenantId());
            mqMessage.put("source", "imageInsertAttach");
            mqMessage.put("createUserId", user.getId());
            mqMessage.put("billCode", request.getBillCode());
            final Map<String, Object> headers = new HashMap<>();
            headers.put(TENANT_CODE, user.getTenantCode());
            rabbitmqUtils.sendByTopicExchange(MQEnum.WEBSOCKET_NOTICE_QUEUE, mqMessage, headers);
        }
        LogUtil.attachSaveCount(CollectionUtils.size(request.getEntities()));
        return CommonResponse.ok("成功", imageIds);
    }

    /**
     * 创建单据
     *
     * @param attachImages attachImages
     */
    private void toAnnex(List<JSONObject> attachImages) {
        if (ValidatorUtil.isEmpty(attachImages)) {
            return;
        }
        attachImages.forEach(image -> {
            //附件保存
            final Long imageId = image.getLong(EntityMeta.Image.ID.code());
            final Long tenantId = image.getLong(EntityMeta.Image.TENANT_ID.code());
            final TicketRecogBean bean = new TicketRecogBean();
            bean.setImageId(imageId);
            bean.setTenantId(tenantId);
            bean.setBatchNo(image.getString(EntityMeta.Image.BATCH_NO.code()));
            bean.setIsPublic(image.getString(EntityMeta.Image.IS_PUBLIC.code()));
            bean.setScanUserId(image.getLong(EntityMeta.Image.CREATE_USER_ID.code()));
            bean.setScanUserName(image.getString(EntityMeta.Image.CREATE_USER_NAME.code()));
            final JSONObject discern = new JSONObject();
            final String billCode = image.getString(EntityMeta.Image.BILL_CODE.code());
            final String billEntityCode = image.getString(EntityMeta.Image.BILL_ENTITY_CODE.code());
            discern.put("bill_code", billCode);
            discern.put("bill_entity_code", billEntityCode);
            discern.put("bill_type_code", image.getString(EntityMeta.Image.BILL_ENTITY_CODE.code()));
            discern.put("serial_number", image.getString(EntityMeta.Image.SERIAL_NUMBER.code()));
            discern.put("system_orig", image.getString(EntityMeta.Image.IMAGE_SOURCE.code()));
            discern.put("system_source", image.getString(EntityMeta.Image.IMAGE_SOURCE.code()));
            discern.put("create_user_code", image.getString(EntityMeta.Image.CREATE_USER_CODE.code()));
            discern.put("org_id", image.getLong(EntityMeta.Image.ORG_ID.code()));
            discern.put("org_code", image.getString(EntityMeta.Image.ORG_CODE.code()));
            discern.put("org_name", image.getString(EntityMeta.Image.ORG_NAME.code()));
            final Map<String, Object> data = new HashMap<>();
            data.put("entityCode", EntityConstant.TICKET_ATTACHMENT);
            data.put("recogJson", discern);
            bean.setRecogList(Collections.singletonList(data));
            logger.info("发送附件，imageId:【{}】,单据号：【{}】，所属单据：【{}】", imageId, billCode, billEntityCode);
            billImageTicketService.insertOrUpdateRecogInfo(bean);
        });
    }

}