package com.xforceplus.elephant.image.controller.logisticsitem;

import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.process.response.ListResult;
import com.xforceplus.elephant.image.client.annotation.ApiV1Image;
import com.xforceplus.elephant.image.client.api.LogisticsItemApi;
import com.xforceplus.elephant.image.client.model.GetLogisticsItemListRequest;
import com.xforceplus.elephant.image.client.model.LogisticsItemDTO;
import com.xforceplus.elephant.image.client.model.SaveLogisticsItemRequest;
import com.xforceplus.elephant.image.client.model.UpdateLogisticsItemRequest;
import com.xforceplus.elephant.image.controller.BaseController;
import com.xforceplus.elephant.image.controller.logisticsitem.process.DeleteLogisticsItemProcess;
import com.xforceplus.elephant.image.controller.logisticsitem.process.GetLogisticsItemDetailProcess;
import com.xforceplus.elephant.image.controller.logisticsitem.process.GetLogisticsItemListProcess;
import com.xforceplus.elephant.image.controller.logisticsitem.process.SaveLogisticsItemProcess;
import com.xforceplus.elephant.image.controller.logisticsitem.process.UpdateLogisticsItemProcess;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 版权：    上海云砺信息科技有限公司 创建者: 创建时间: 功能描述: 修改历史:
 */
@ApiV1Image
public class LogisticsItemController extends BaseController implements LogisticsItemApi {

    @Autowired
    private DeleteLogisticsItemProcess deleteLogisticsItemProcess;
    @Autowired
    private GetLogisticsItemDetailProcess getLogisticsItemDetailProcess;
    @Autowired
    private GetLogisticsItemListProcess getLogisticsItemListProcess;
    @Autowired
    private SaveLogisticsItemProcess saveLogisticsItemProcess;
    @Autowired
    private UpdateLogisticsItemProcess updateLogisticsItemProcess;

    @Override
    public CommonResponse<Boolean> deleteLogisticsItem(@PathVariable("logisticsItemId") Long logisticsItemId, @RequestBody BaseRequest request) {
        return deleteLogisticsItemProcess.execute(logisticsItemId, request);
    }

    @Override
    public CommonResponse<LogisticsItemDTO> getLogisticsItemDetail(@PathVariable("logisticsItemId") Long logisticsItemId, BaseRequest request) {
        return getLogisticsItemDetailProcess.execute(logisticsItemId, request);
    }

    @Override
    public CommonResponse<ListResult<LogisticsItemDTO>> getLogisticsItemList(GetLogisticsItemListRequest request) {
        return getLogisticsItemListProcess.execute(request);
    }

    @Override
    public CommonResponse<List<Long>> saveLogisticsItem(@RequestBody SaveLogisticsItemRequest request) {
        return saveLogisticsItemProcess.execute(request);
    }

    @Override
    public CommonResponse<Boolean> updateLogisticsItem(@RequestBody UpdateLogisticsItemRequest request) {
        return updateLogisticsItemProcess.execute(request);
    }

}