package com.xforceplus.elephant.image.controller.ticket.process;

import com.xforceplus.elephant.basecommon.help.StringHelp;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.DeleteTicketListRequest;
import com.xforceplus.elephant.image.core.domain.image.ImageService;
import com.xforceplus.elephant.image.core.domain.operationlog.OperationLogService;
import com.xforceplus.elephant.image.core.expand.BillImageTicketService;
import com.xforceplus.elephant.image.core.expand.compare.impl.billimageticket.DefaultCompareBillImageTicketServiceImpl;
import com.xforceplus.elephant.image.core.facade.application.collect.ticket.TicketFacade;
import com.xforceplus.elephant.image.core.util.RequestBuilder;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.OperationEntity;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.OperationType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Ticket;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionOp;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 运维单证删除
 * @author rongying
 * @date 2021/12/31 14:06
 */
@Service
public class OperationDeleteTicketProcess extends AbstractProcess<DeleteTicketListRequest, Boolean> {

    @Autowired
    private BillImageTicketService billImageTicketService;
    @Autowired
    private DefaultCompareBillImageTicketServiceImpl compareBillImageTicketService;
    @Autowired
    private TicketFacade ticketFacade;
    @Autowired
    private ImageService imageService;
    @Autowired
    private OperationLogService operationLogService;

    @Override
    protected void check(DeleteTicketListRequest request) throws ValidationException {
        super.check(request);
        if (ValidatorUtil.isEmpty(request.getTicketIds())) {
            throw new ValidationException("单证ID集合【ticketIds】不能为空");
        }
    }

    @Override
    protected CommonResponse<Boolean> process(DeleteTicketListRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        final RequestBuilder requestBuilder = new RequestBuilder()
            .field(EntityMeta.Ticket.ID.code(), ConditionOp.in, request.getTicketIds());
        final List<Ticket> entities = ticketFacade.selectTicketByParams(authorizedUser.getTenantId(), requestBuilder, request.getTicketCode());
        if (ValidatorUtil.isEmpty(entities)) {
            return CommonResponse.failed("未查询到数据");
        }
        final List<Long> imageIds = entities.stream().map(r -> r.getImageId()).collect(Collectors.toList());
        //JXCPX-5561 【碧桂园物业】删除及挂接发票会连带附件处理问题
        //查询发票下挂接的附件，然后一并删除
        /*if (ValidatorUtil.isNotEmpty(imageIds)) {
            final List<Long> attachmentAndSalesImageId = imageService.selectTicketAttachmentAndSalesList(authorizedUser.getTenantId(), imageIds).stream().map(Image::getId)
                .collect(Collectors.toList());
            imageIds.addAll(attachmentAndSalesImageId);
        }*/
        if (ValidatorUtil.isEmpty(imageIds)) {
            return CommonResponse.failed("没有找到可操作的数据");
        }
        //删除操作
        return excuateDelete(authorizedUser.getTenantId(), imageIds, request.getTicketCode(), authorizedUser.getUsername());
    }

    /**
     * 单证池删除
     *
     * @param tenantId   租户ID
     * @param imageIds   影像IDs
     * @return void
     * @author rongying
     * @date 2021/8/18 14:40
     */
    private CommonResponse excuateDelete(Long tenantId, List<Long> imageIds, String ticketCode, String userName) {
        //查询单证信息
        final List<Ticket> deleteList = ticketFacade.selectBaseTicketByImageIds(tenantId, imageIds, ticketCode);
        if (ValidatorUtil.isEmpty(deleteList)) {
            return CommonResponse.failed("没有找到可操作的数据");
        }
        //删除
        final boolean isCompare = StringUtils.startsWith(ticketCode, "compare");
        final boolean result;
        if (isCompare) {
            result = compareBillImageTicketService.deleteImageAndTicketByImageIds(tenantId, imageIds);
        } else {
            result = billImageTicketService.deleteImageAndTicketByImageIds(tenantId, imageIds);
        }
        if (result) {
            //记录运维日志
            deleteList.forEach(r -> operationLogService.insertOperationLog(OperationEntity.TICKET.getCode(), StringHelp.safeToString(r.getId()), OperationType.DELETE_TICKET.getCode(),
                    userName, ""));
            return CommonResponse.ok("删除成功", true);
        } else {
            return CommonResponse.failed("无记录删除");
        }
    }

}