package com.xforceplus.elephant.image.controller.ticket.process;

import com.xforceplus.elephant.basecommon.annotation.Dispatch;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.SaveTicketLabelsRequest;
import com.xforceplus.elephant.image.core.business.application.collect.label.service.SystemLabelService;
import com.xforceplus.elephant.image.core.facade.application.collect.ticket.TicketFacade;
import com.xforceplus.elephant.image.core.util.ValidateUtils;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import javax.validation.ValidationException;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Dispatch(isDefault = true)
@Service
public class TicketSaveLabelsProcess extends AbstractProcess<SaveTicketLabelsRequest, Boolean> {

    @Autowired
    private SystemLabelService systemLabelService;

    @Autowired
    private TicketFacade ticketFacade;

    @Override
    protected void check(SaveTicketLabelsRequest request) throws ValidationException {
        // 基础校验
        ValidateUtils.validate(request);

        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        // 标签合法性校验
        if (CollectionUtils.isNotEmpty(request.getLabelIdList())) {
            final int count = systemLabelService.countLabel(authorizedUser.getTenantId(), request.getLabelIdList());
            ValidateUtils.checkArgument(count != request.getLabelIdList().size(), "存在非当前租户的无效标签");
        }
    }

    @Override
    protected CommonResponse<Boolean> process(SaveTicketLabelsRequest request) throws RuntimeException {
        ticketFacade.saveLabels(request.getIds(), request.getLabelIdList());
        return CommonResponse.ok("成功", true);
    }

}