package com.xforceplus.elephant.image.mapper;

import com.xforceplus.elephant.image.client.model.BillSelectAllRequest;
import com.xforceplus.elephant.image.client.model.GetImageListRequest;
import com.xforceplus.elephant.image.client.model.ImageDTO;
import com.xforceplus.elephant.image.client.model.SendVerifyRequest;
import com.xforceplus.elephant.image.core.domain.image.bean.ImageSearchBean;
import com.xforceplus.elephant.image.core.domain.image.bean.ImageSearchResultBean;
import com.xforceplus.elephant.image.core.facade.dto.statistics.TicketStatisticsDto;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2025-10-20T09:37:17+0800",
    comments = "version: 1.4.1.Final, compiler: javac, environment: Java 1.8.0_111 (Oracle Corporation)"
)
@Component
public class ImageSearchMapperImpl implements ImageSearchMapper {

    @Override
    public ImageSearchBean map(GetImageListRequest request) {
        if ( request == null ) {
            return null;
        }

        ImageSearchBean imageSearchBean = new ImageSearchBean();

        imageSearchBean.setRid( request.getRid() );
        imageSearchBean.setPageNo( request.getPageNo() );
        imageSearchBean.setPageSize( request.getPageSize() );
        imageSearchBean.setOrderByClause( request.getOrderByClause() );
        List<Long> list = request.getImageIds();
        if ( list != null ) {
            imageSearchBean.setImageIds( new ArrayList<Long>( list ) );
        }
        imageSearchBean.setBillCode( request.getBillCode() );
        imageSearchBean.setExceptionStatus( request.getExceptionStatus() );
        imageSearchBean.setInvoiceType( request.getInvoiceType() );
        Map<String, String> map = request.getTicketParams();
        if ( map != null ) {
            imageSearchBean.setTicketParams( new HashMap<String, String>( map ) );
        }

        return imageSearchBean;
    }

    @Override
    public ImageSearchBean map(BillSelectAllRequest request) {
        if ( request == null ) {
            return null;
        }

        ImageSearchBean imageSearchBean = new ImageSearchBean();

        imageSearchBean.setRid( request.getRid() );
        imageSearchBean.setPageNo( request.getPageNo() );
        imageSearchBean.setPageSize( request.getPageSize() );
        imageSearchBean.setOrderByClause( request.getOrderByClause() );
        List<Long> list = request.getImageIds();
        if ( list != null ) {
            imageSearchBean.setImageIds( new ArrayList<Long>( list ) );
        }
        imageSearchBean.setBillCode( request.getBillCode() );
        imageSearchBean.setExceptionStatus( request.getExceptionStatus() );
        imageSearchBean.setInvoiceType( request.getInvoiceType() );
        Map<String, String> map = request.getTicketParams();
        if ( map != null ) {
            imageSearchBean.setTicketParams( new HashMap<String, String>( map ) );
        }

        return imageSearchBean;
    }

    @Override
    public ImageSearchBean map(SendVerifyRequest request) {
        if ( request == null ) {
            return null;
        }

        ImageSearchBean imageSearchBean = new ImageSearchBean();

        imageSearchBean.setRid( request.getRid() );
        imageSearchBean.setPageNo( request.getPageNo() );
        imageSearchBean.setPageSize( request.getPageSize() );
        imageSearchBean.setOrderByClause( request.getOrderByClause() );
        List<Long> list = request.getImageIds();
        if ( list != null ) {
            imageSearchBean.setImageIds( new ArrayList<Long>( list ) );
        }
        imageSearchBean.setBillCode( request.getBillCode() );
        imageSearchBean.setExceptionStatus( request.getExceptionStatus() );
        imageSearchBean.setInvoiceType( request.getInvoiceType() );
        Map<String, String> map = request.getTicketParams();
        if ( map != null ) {
            imageSearchBean.setTicketParams( new HashMap<String, String>( map ) );
        }

        return imageSearchBean;
    }

    @Override
    public ImageDTO map(Image image) {
        if ( image == null ) {
            return null;
        }

        ImageDTO imageDTO = new ImageDTO();

        imageDTO.setSystemOrig( image.getImageSource() );
        imageDTO.setImageSource( image.getImageSource() );
        imageDTO.setId( image.getId() );
        imageDTO.setTenantId( image.getTenantId() );
        imageDTO.setBillCode( image.getBillCode() );
        imageDTO.setBatchNo( image.getBatchNo() );
        imageDTO.setImageCategory( image.getImageCategory() );
        imageDTO.setImageType( image.getImageType() );
        imageDTO.setRequireOcrFlag( image.getRequireOcrFlag() );
        imageDTO.setFileUrl( image.getFileUrl() );
        imageDTO.setFileUrlHandle( image.getFileUrlHandle() );
        imageDTO.setFileUrlOrigin( image.getFileUrlOrigin() );
        imageDTO.setFileType( image.getFileType() );
        imageDTO.setFileTypeHandle( image.getFileTypeHandle() );
        imageDTO.setFileOrder( image.getFileOrder() );
        if ( image.getFileLevel() != null ) {
            imageDTO.setFileLevel( String.valueOf( image.getFileLevel() ) );
        }
        imageDTO.setRecStatus( image.getRecStatus() );
        imageDTO.setTaskId( image.getTaskId() );
        if ( image.getCopyCount() != null ) {
            imageDTO.setCopyCount( String.valueOf( image.getCopyCount() ) );
        }
        imageDTO.setBillImageId( image.getBillImageId() );
        imageDTO.setTicketImageId( image.getTicketImageId() );
        imageDTO.setStatus( image.getStatus() );
        imageDTO.setIsManualUnhook( image.getIsManualUnhook() );
        imageDTO.setIsPublic( image.getIsPublic() );
        imageDTO.setExceptionStatus( image.getExceptionStatus() );
        imageDTO.setReturnStatus( image.getReturnStatus() );
        imageDTO.setReturnReason( image.getReturnReason() );
        imageDTO.setReturnRemark( image.getReturnRemark() );
        imageDTO.setCreateUserId( image.getCreateUserId() );
        imageDTO.setCreateUserName( image.getCreateUserName() );
        imageDTO.setUpdateUserId( image.getUpdateUserId() );
        imageDTO.setUpdateUserName( image.getUpdateUserName() );
        imageDTO.setReserved1( image.getReserved1() );
        imageDTO.setReserved2( image.getReserved2() );
        imageDTO.setReserved3( image.getReserved3() );
        imageDTO.setIsReuse( image.getIsReuse() );
        imageDTO.setPageCode( image.getPageCode() );
        imageDTO.setBillEntityCode( image.getBillEntityCode() );
        imageDTO.setCreateUserCode( image.getCreateUserCode() );
        imageDTO.setMoreFileUrl( image.getMoreFileUrl() );
        imageDTO.setExceptionInfo( image.getExceptionInfo() );
        imageDTO.setWarningInfo( image.getWarningInfo() );
        imageDTO.setIsCommit( image.getIsCommit() );
        imageDTO.setCommitUserId( image.getCommitUserId() );
        imageDTO.setCommitUserName( image.getCommitUserName() );
        imageDTO.setReturnType( image.getReturnType() );
        imageDTO.setFileName( image.getFileName() );
        imageDTO.setOrgId( image.getOrgId() );
        imageDTO.setOrgCode( image.getOrgCode() );
        imageDTO.setOrgName( image.getOrgName() );
        imageDTO.setCalculateStatus( image.getCalculateStatus() );
        imageDTO.setTicketCode( image.getTicketCode() );
        imageDTO.setFileId( image.getFileId() );
        imageDTO.setSerialNumber( image.getSerialNumber() );

        return imageDTO;
    }

    @Override
    public ImageSearchResultBean map(TicketStatisticsDto dto) {
        if ( dto == null ) {
            return null;
        }

        ImageSearchResultBean imageSearchResultBean = new ImageSearchResultBean();

        imageSearchResultBean.setTotalImageNum( dto.getTotalNum() );
        imageSearchResultBean.setTotalAmountWithTax( dto.getTotalAmountWithTax() );
        imageSearchResultBean.setTotalTaxAmount( dto.getTotalTaxAmount() );

        return imageSearchResultBean;
    }
}
