package com.xforceplus.elephant.image.servicehandler;

import com.alibaba.fastjson.JSON;
import com.xforceplus.elephant.basecommon.dispatch.BeanDispatcher;
import com.xforceplus.elephant.basecommon.enums.common.PageCodeEnum;
import com.xforceplus.elephant.image.core.util.CommonEntityServiceHandler;
import com.xforceplus.elephant.image.core.util.RequestParser;
import com.xforceplus.elephant.image.servicehandler.newbasebill.DefaultNewBaseBillService;
import com.xforceplus.general.ultraman.store.UltramanDataStoreFacadeWrapper;
import com.xforceplus.tech.base.core.dispatcher.anno.QueryHandler;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta.BaseBill;
import com.xforceplus.ultraman.metadata.domain.vo.Page;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.sdk.core.cmd.ConditionSearchCmd;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Slf4j
@RequiredArgsConstructor
@Service
public class NewCompareBaseBillService extends CommonEntityServiceHandler {

    private final BeanDispatcher beanDispatcher;
    private final UltramanDataStoreFacadeWrapper ultramanDataStoreFacadeWrapper;

    @Value("${image.page.search.firstDB.tenantCodes:}")
    private List<String> firstDBTenantCodes;

    public static final String PAGE_CODE_COMPARE_BILL = "compareBill";

    /**
     * 支持索引的查询条件
     */
    private List<String> indexFields = Arrays.asList(BaseBill.TENANT_ID.code(), BaseBill.BILL_DATA_STATUS.code(), BaseBill.AUDIT_STATUS.code(), BaseBill.CREATE_USER_NAME.code());

    @QueryHandler(condition = "msg.getMetaData().get('codes').contains('compareBaseBill')")
    @Override
    public Either<String, Tuple2<Integer, List<Map<String, Object>>>> conditionSearch(ConditionSearchCmd cmd) {
        // 获取登录用户上下文
        final IAuthorizedUser user = UserInfoHolder.get();
        final boolean flag = beanDispatcher.dispatch(user.getTenantId(), DefaultNewBaseBillService.class)
            .handleConditionSearch(user, cmd.getPageCode(), cmd.getConditionQueryRequest());
        if (!flag) {
            return Either.right(new Tuple2<>(0, new ArrayList<>()));
        }
        log.info("compareBill二开查询条件:{}", JSON.toJSONString(cmd));
        //财务稽核页面，属于优先db查询的租户且查询条件符合索引查询，则使用数据库查询
        if (PAGE_CODE_COMPARE_BILL.equals(cmd.getPageCode())
            && CollectionUtils.isNotEmpty(firstDBTenantCodes) && firstDBTenantCodes.contains(user.getTenantCode())
            && firstDB(cmd)) {
            return dbSearch(cmd);
        }
        return super.conditionSearch(cmd);
    }

    /**
     * 根据查询条件判定优先db
     * @param cmd 查询条件
     * @return 是否查询db
     */
    private boolean firstDB(final ConditionSearchCmd cmd) {
        //查询的class如果不存在，走默认查询
        final Optional<IEntityClass> entityClassOp = this.getEntityClass(cmd);
        if (!entityClassOp.isPresent()) {
            return false;
        }
        final RequestParser parser = RequestParser.parse(cmd.getConditionQueryRequest());
        return indexFields.stream().allMatch(field -> CollectionUtils.isNotEmpty(parser.value(field)));
    }

    /**
     * db查询
     * @param cmd 查询条件
     * @return db查询结果
     */
    private Either<String, Tuple2<Integer, List<Map<String, Object>>>> dbSearch(final ConditionSearchCmd cmd) {
        final IAuthorizedUser user = UserInfoHolder.get();
        final IEntityClass entityClass = this.getEntityClass(cmd).orElse(null);
        try {
            log.info("compareBill二开查询条件，使用数据库查询:{}", JSON.toJSONString(cmd.getConditionQueryRequest()));
            final Page<Map<String, Object>> page = ultramanDataStoreFacadeWrapper.findPageMapByCondition(user.getTenantCode(), entityClass, cmd.getConditionQueryRequest());
            return Either.right(new Tuple2<>((int) page.getSummary().getTotal(), page.getRows()));
        } catch (Exception e) {
            log.error(String.format("compareBill二开查询条件，条件查询异常：%s", JSON.toJSONString(cmd.getConditionQueryRequest())), e);
            return super.conditionSearch(cmd);
        }

    }

}

