package com.xforceplus.elephant.image.config;

import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.google.common.base.Joiner;
import com.xforceplus.xplatalarm.content.ExceptionNotice;
import io.vavr.control.Try;
import java.net.InetAddress;
import org.springframework.util.DigestUtils;

/**
 * @author zhuxingsheng@gmail.com
 * @description: TODO
 * @date 2022/6/5 21:45
 */
public class SentinelExceptionNotice extends ExceptionNotice {

    private BlockException blockException;

    public SentinelExceptionNotice(final BlockException blockException) {
        super(blockException);
        this.blockException = blockException;
    }

    public SentinelExceptionNotice(final String traceId, final Throwable ex, final String filterTrace, final Object[] args) {
        super(traceId, ex, filterTrace, args);
    }

    @Override
    public String createText() {
        final StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[Sentinel限流监控]\r\n");
        stringBuilder.append("appName：").append(this.project).append("\r\n");
        stringBuilder.append("env：").append(System.getProperty("env")).append("\r\n");
        stringBuilder.append("host：").append(Try.of(() -> InetAddress.getLocalHost())
            .map(addr -> Joiner.on(":").join(addr.getHostName(), addr.getHostAddress())).getOrNull()).append("\r\n");
        stringBuilder.append("rule：").append(this.blockException.getRule()).append("\r\n");
        return stringBuilder.toString();
    }

    @Override
    protected String calUid() {
        final String md5 = DigestUtils.md5DigestAsHex(((BlockException) getException()).getRule().getResource().getBytes());
        return md5;
    }

}
