package com.xforceplus.elephant.image.controller.billdata.process.commit;

import com.xforceplus.elephant.basecommon.annotation.Dispatch;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.BaseBillCommitRequest;
import com.xforceplus.elephant.image.client.model.EntityObj;
import com.xforceplus.elephant.image.core.domain.multipurpose.MultipurposeService;
import com.xforceplus.elephant.image.core.facade.application.collect.bill.BillFacade;
import com.xforceplus.elephant.image.core.facade.application.collect.ticket.TicketFacade;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Ticket;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta.BaseBill;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.validation.ValidationException;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Dispatch(tenantCode = "BWCJ")
@Service
public class BWCJBillDataCommitProcess extends BillDataCommitProcess {

    private final Tuple2<Function<Ticket, BigDecimal>, String> checkUsedAmount = Tuple.of((ticket) -> ticket.getUsedAmount() == null ? BigDecimal.ZERO : ticket.getUsedAmount(),
        "单据金额与单证占用之和金额不相等，请核实！");
    private final Tuple2<Function<Ticket, BigDecimal>, String> checkAmountWithTax = Tuple.of((ticket) -> ticket.getAmountWithTax() == null ? BigDecimal.ZERO : ticket.getAmountWithTax(),
        "单据含税金额与单证含税之和金额不相等，请核实！");
    @Autowired
    private TicketFacade ticketFacade;
    @Autowired
    private BillFacade billFacade;
    @Autowired
    private MultipurposeService multipurposeService;

    @Override
    protected void check(BaseBillCommitRequest request) throws ValidationException {
        super.check(request);
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();// 获取登录用户上下文
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        checkEmpty(request.getEntities(), "entities不能为空");

        final Tuple2<Function<Ticket, BigDecimal>, String> checkAmountFunction = multipurposeService.isMultipurposeEnabled(authorizedUser.getTenantId()) ? checkUsedAmount : checkAmountWithTax;

        for (final EntityObj entity : request.getEntities()) {
            final Map<String, Object> billMap = billFacade.selectBillMapByCode(authorizedUser.getTenantId(), entity.getBillCode(), EntityMeta.BaseBill.code());
            final String amountWithTaxStr = MapUtils.getString(billMap, BaseBill.BILL_AMOUNT_WITH_TAX.code());
            final BigDecimal billAmountWithTax = ValidatorUtil.isAmount(amountWithTaxStr) ? new BigDecimal(amountWithTaxStr) : BigDecimal.ZERO;

            if (billAmountWithTax.compareTo(BigDecimal.ZERO) == 0) {
                throw new ValidationException("单据含税金额不能为0，请核实！");
            }

            final Optional<BigDecimal> ticketTotalAmount = ticketFacade.selectBaseTicketByBillCode(authorizedUser.getTenantId(), entity.getBillCode())
                                                                       .stream()
                                                                       .map(checkAmountFunction._1)
                                                                       .reduce(BigDecimal::add);

            if (!ticketTotalAmount.isPresent() || billAmountWithTax.compareTo(ticketTotalAmount.get()) != 0) {
                throw new ValidationException(checkAmountFunction._2);
            }
        }

    }

}
