package com.xforceplus.elephant.image.controller.common.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.xforceplus.elephant.basecommon.baseconst.ConfigConstants;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.core.business.application.collect.bill.domain.BillTypeInfo;
import com.xforceplus.elephant.image.core.business.application.collect.ticket.domain.TicketCheckContentConfig;
import com.xforceplus.elephant.image.core.business.application.collect.ticket.domain.TicketTypeInfo;
import com.xforceplus.elephant.image.core.business.application.config.common.service.ConfigService;
import com.xforceplus.elephant.image.core.business.consts.ConfigTypeEnum;
import com.xforceplus.elephant.image.core.business.consts.Constants;
import com.xforceplus.elephant.image.core.business.consts.SettingProperties;
import com.xforceplus.elephant.image.core.business.consts.VerifyConstants;
import com.xforceplus.elephant.image.core.business.enums.DictEnum;
import com.xforceplus.elephant.image.core.domain.config.ConfigSettingsService;
import com.xforceplus.elephant.image.core.domain.config.bean.ConfigDictionaryItem;
import com.xforceplus.elephant.image.core.facade.base.BaseFacade;
import com.xforceplus.elephant.image.core.util.RequestBuilder;
import com.xforceplus.general.core.web.parse.ExpressionSelector;
import com.xforceplus.general.utils.EnumUtil;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.YesNo;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.ConfigDictionary;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionOp;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionQueryRequest;
import io.vavr.Tuple;
import io.vavr.Tuple2;

import java.util.*;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.RequiredArgsConstructor;
import lombok.var;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
@RequiredArgsConstructor
public class GetConfigSettingProcess extends AbstractProcess<BaseRequest, Object> {

    private final ConfigSettingsService configSettingsService;
    private final SettingProperties settingProperties;
    private final ConfigService configService;
    private final BaseFacade baseFacade;

    @Override
    protected CommonResponse<Object> process(final BaseRequest request) throws RuntimeException {
        final String code = request.getRid();
        final IAuthorizedUser user = UserInfoHolder.get();
        // 数据源
        final Map<String, Object> data = Maps.newHashMap();
        String template = null;

        final ConfigTypeEnum typeEnum = EnumUtil.fromValue(ConfigTypeEnum.class, code);

        if (ConfigTypeEnum.BASE.equals(typeEnum)) {
            template = settingProperties.getBaseSchema();

            final JSONObject baseConfig = configSettingsService.select(user.getTenantId(), false);
            data.put("base", baseConfig);
        } else if (ConfigTypeEnum.WATERMARK.equals(typeEnum)) {
            template = settingProperties.getWaterSchema();
            final Set<Option> billList = new LinkedHashSet<>();
            billList.add(new Option("全部", "all", EntityMeta.BaseBill.code()));
            Optional.ofNullable(configService.selectDict(user.getTenantId(), DictEnum.BILL_TYPE_CONFIG.getCode(), BillTypeInfo.class))
                .ifPresent(billTypeInfos -> billTypeInfos
                    .forEach(billTypeInfo -> billTypeInfo.getBillType()
                        .forEach(billType -> billList.add(new Option(billType.getBoName(), billType.getBoCode(), billType.getBoCode())))));
            data.put("billList", JSON.toJSONString(billList));
            final Set<Option> ticketList = new LinkedHashSet<>();
            ticketList.add(new Option("全部", "all", EntityMeta.Ticket.code()));
            Optional.ofNullable(configService.selectDict(user.getTenantId(), DictEnum.TICKET_TYPE_CONFIG.getCode(), TicketTypeInfo.class))
                .ifPresent(ticketTypeInfos -> ticketTypeInfos
                    .forEach(ticketTypeInfo -> ticketTypeInfo.getTicketType()
                        .forEach(ticketType -> ticketList.add(new Option(ticketType.getInvoiceTypeName(), ticketType.getInvoiceType(), ticketType.getBoCode())))));
            data.put("ticketList", JSON.toJSONString(ticketList));
            configService.selectDict(user.getTenantId(), DictEnum.WATERMARK_CONFIG.getCode());
            final JSONObject watermarkConfig = configService.selectDictObj(user.getTenantId(), DictEnum.WATERMARK_CONFIG.getCode(), JSONObject.class);
            data.put("config", watermarkConfig);
            //更新时间、更新人
            final ConditionQueryRequest dictRequest = new RequestBuilder()
                .field(EntityMeta.ConfigDictionary.TENANT.code(), ConditionOp.eq, user.getTenantId())
                .field(EntityMeta.ConfigDictionary.DICT_CODE.code(), ConditionOp.eq, DictEnum.WATERMARK_CONFIG.getCode())
                .field(EntityMeta.ConfigDictionary.ENABLE.code(), ConditionOp.eq, YesNo._1.getCode())
                .build();
            baseFacade.findByCondition(EntityMeta.ConfigDictionary.code(), dictRequest).getRows().forEach(map -> {
                watermarkConfig.put(EntityMeta.ConfigDictionary.UPDATE_USER_NAME.code(), map.get(EntityMeta.ConfigDictionary.UPDATE_USER_NAME.code()));
                watermarkConfig.put(EntityMeta.ConfigDictionary.UPDATE_TIME.code(), map.get(EntityMeta.ConfigDictionary.UPDATE_TIME.code()));
            });
        } else if (ConfigTypeEnum.REC_TICKET_CODE.equals(typeEnum)) {
            template = settingProperties.getRecTicketCodeSchema();
            final JSONObject baseConfig = configSettingsService.select(user.getTenantId(), false);
            data.put("base", baseConfig);
        } else if (ConfigTypeEnum.COVER_TICKET.equals(typeEnum)) {
            template = settingProperties.getCoverTicketSchema();
            final ConfigDictionary configDictionary = Optional.ofNullable(configService.selectDictionaryWithoutEnable(user.getTenantId(), DictEnum.TICKET_COVER_CONFIG.getCode()))
                .orElse(new ConfigDictionary());
            data.put("base", configDictionary.toOQSMap());
        } else if (ConfigTypeEnum.DEL_SUB_UNHOOK_TICKET.equals(typeEnum)) {
            template = settingProperties.getDelSubUnHookTicketSchema();
            final ConfigDictionary configDictionary = Optional.ofNullable(configService.selectDictionary(user.getTenantId(), DictEnum.TICKET_DELETE_CONFIG.getCode()))
                .orElse(new ConfigDictionary());
            final var dictConfigValue = JSON.parseArray(configDictionary.getDictValue());
            final Map<String, Object> baseConfig = configDictionary.toOQSMap();
            baseConfig.put("enable", getEnabled(dictConfigValue, user.getTenantId()));
            data.put("base", baseConfig);
        } else if (ConfigTypeEnum.VERIFY_FIELD_ORIGINAL.equals(typeEnum)) {
            template = settingProperties.getVerifyFieldOriginal();
            final ConfigDictionary configDictionary = Optional.ofNullable(configService.selectDictionary(user.getTenantId(), ConfigConstants.CONFIG_DICT_CODE_TICKET_CHEKCT_CONTENT))
                .orElse(new ConfigDictionary());
            final List<ConfigDictionaryItem> configList = Optional.ofNullable(configDictionary.getDictValue())
                .filter(StringUtils::isNotBlank)
                .map(value -> JSON.parseArray(value, ConfigDictionaryItem.class))
                .orElse(Collections.emptyList());
            final Map<String, Object> baseConfig = configDictionary.toOQSMap();
            final String verifyFieldOriginalValue = configList.stream()
                .filter(config -> VerifyConstants.VERIFY_FIELD_ORIGINAL.equals(config.getItemCode()))
                .findFirst()
                .map(ConfigDictionaryItem::getItemValue)
                .orElse(StringUtils.EMPTY);
            baseConfig.put(VerifyConstants.VERIFY_FIELD_ORIGINAL, verifyFieldOriginalValue);
            data.put("base", baseConfig);
        }

        final String result = ExpressionSelector.JET.getParser().parse(template, data);
        final JSONObject retJson;
        try {
            retJson = JSON.parseObject(result);
        } catch (final Exception e) {
            logger.error("", e);
            return CommonResponse.failed("配置元数据模板格式有误");
        }
        settingProperties.analysisEnum(retJson);
        return CommonResponse.ok("成功", retJson);
    }

    private String getEnabled(final JSONArray configs, final Long tenantId) {
        final var ruleMap = getRuleMap(tenantId);
        for (Object item : configs) {
            final JSONObject config = (JSONObject) item;
            final String expression = config.getString("notDeleteExpression");

            for (String ruleExpression : ruleMap.keySet()) {
                final var ruleTuple2 = ruleMap.get(ruleExpression);
                if (StringUtils.equalsIgnoreCase(ruleExpression, expression)) {
                    return ruleTuple2._2();
                }
            }
        }
        return Constants.ZERO;
    }

    /**
     * key = expression, value = key,value
     *
     * @return Map
     */
    private Map<String, Tuple2<String, String>> getRuleMap(final Long tenantId) {
        final Map<String, Tuple2<String, String>> expMap = Maps.newHashMap();

        final JSONArray ruleConfigs = JSON.parseArray(configService.selectDict(tenantId, DictEnum.TICKET_DELETE_CONFIG_RULE.getCode()));
        for (Object item : ruleConfigs) {
            final JSONObject config = (JSONObject) item;
            expMap.put(config.getString("expression"), Tuple.of(config.getString("key"), config.getString("value")));
        }
        return expMap;
    }

    @Data
    @AllArgsConstructor
    @EqualsAndHashCode
    class Option {

        private String label;
        private String value;
        private String code;

    }

}
