package com.xforceplus.elephant.image.controller.compare.ticket.process;

import com.google.common.collect.Lists;
import com.xforceplus.elephant.basecommon.help.StringHelp;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.GetExceAndWarnInfoRequest;
import com.xforceplus.elephant.image.core.domain.common.TicketSupport;
import com.xforceplus.elephant.image.core.domain.compare.bill.CompareBaseBillService;
import com.xforceplus.elephant.image.core.domain.compare.ticket.CompareTicketService;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.ImageType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.YesNo;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BaseBill;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Ticket;
import java.util.Arrays;
import java.util.List;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CompareGetExceAndWarnInfoProcess extends AbstractProcess<GetExceAndWarnInfoRequest, List<String>> {

    @Autowired
    private CompareBaseBillService baseBillService;
    @Autowired
    private CompareTicketService ticketService;
    @Autowired
    private TicketSupport ticketSupport;

    @Override
    protected void check(GetExceAndWarnInfoRequest request) throws ValidationException {
        super.check(request);
        if (ValidatorUtil.isEmpty(request.getImageId())) {
            throw new ValidationException("影像ID【imageId】不能为空");
        }
        if (ValidatorUtil.isEmpty(request.getImageType())) {
            throw new ValidationException("影像类型【imageType】不能为空");
        }
    }

    @Override
    protected CommonResponse<List<String>> process(GetExceAndWarnInfoRequest request) throws RuntimeException {
        final List<String> resultList = Lists.newArrayList();
        if (ImageType._1.getCode().equals(request.getImageType())) {
            final BaseBill dataEntity = baseBillService.selectBillDataByImageId(request.getImageId());
            if (null != dataEntity && YesNo._1.getCode().equals(dataEntity.getIsException())) {
                final String exceptionInfo = StringHelp.safeToString(dataEntity.getExceptionInfo());
                resultList.addAll(Arrays.asList(exceptionInfo.split(";")));
            }
            if (null != dataEntity && YesNo._1.getCode().equals(dataEntity.getIsWarning())) {
                final String warningInfo = StringHelp.safeToString(dataEntity.getWarningInfo());
                resultList.addAll(Arrays.asList(warningInfo.split(";")));
            }
        }
        if (ImageType._2.getCode().equals(request.getImageType())
            || ImageType._3.getCode().equals(request.getImageType())
            || ticketSupport.isAttachSalesImage(request.getImageType())) {
            final List<Ticket> ticketList = ticketService.selectBaseTicketByImageID(request.getImageId());
            if (!CollectionUtils.isEmpty(ticketList)) {
                ticketList.stream().filter(r -> YesNo._1.getCode().equals(r.getExceptionStatus()))
                    .forEach(r -> {
                        final String exceptionInfo = StringHelp.safeToString(r.getExceptionInfo());
                        resultList.addAll(Arrays.asList(exceptionInfo.split(";")));
                    });
                ticketList.stream().filter(r -> YesNo._1.getCode().equals(r.getWarningStatus()))
                    .forEach(r -> {
                        final String warningInfo = StringHelp.safeToString(r.getWarningInfo());
                        resultList.addAll(Arrays.asList(warningInfo.split(";")));
                    });
            }
        }
        return CommonResponse.ok("成功", resultList);
    }

}