package com.xforceplus.elephant.image.controller.compare.ticket.process;

import com.alibaba.fastjson.JSON;
import com.xforceplus.elephant.basecommon.help.StringHelp;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.GetTicketDataRequest;
import com.xforceplus.elephant.image.core.domain.compare.image.CompareImageService;
import com.xforceplus.elephant.image.core.domain.compare.ticket.CompareTicketService;
import com.xforceplus.elephant.image.core.domain.config.ConfigSettingsService;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.YesNo;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Ticket;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta.ConfigSettings;
import java.util.Map;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CompareGetTicketDataProcess extends AbstractProcess<GetTicketDataRequest, Map<String, Object>> {

    @Autowired
    private CompareTicketService ticketService;
    @Autowired
    private CompareImageService imageService;
    @Autowired
    private ConfigSettingsService configSettingsService;

    @Override
    protected void check(GetTicketDataRequest request) throws ValidationException {
        super.check(request);
        if (ValidatorUtil.isEmpty(request.getTicketId())) {
            throw new ValidationException("单证ID【ticketId】不能为空");
        }
    }

    @Override
    protected CommonResponse<Map<String, Object>> process(GetTicketDataRequest request) throws RuntimeException {
        final Map<String, Object> map;
        if (ValidatorUtil.isEmpty(request.getTicketCode()) || EntityMeta.CompareTicket.code().equals(request.getTicketCode())) {
            final Ticket ticket = ticketService.selectBaseTicketById(request.getTicketId());
            if (null == ticket) {
                return CommonResponse.failed("没有查询到单证数据.");
            }
            map = ticketService.selectByParentTicketID(EntityMeta.CompareTicket.code(), ticket.getTicketCode(), request.getTicketId());
        } else {
            map = ticketService.selectByTicketCode(request.getTicketCode(), request.getTicketId());
        }
        if (null == map) {
            return CommonResponse.failed("没有查询到单证数据.");
        }
        //电票源文件名称
        final Long tenantId = Long.valueOf(StringHelp.safeToString(map.get(EntityMeta.Ticket.TENANT_ID.code())));
        final Long imageId = Long.valueOf(StringHelp.safeToString(map.get(EntityMeta.Ticket.IMAGE_ID.code())));
        final Image image = imageService.selectOne(tenantId, imageId);
        if (image != null) {
            map.put("file_name", image.getFileName());
            final Map<String, Object> extValue = JSON.parseObject(JSON.toJSONString(image));
            extValue.entrySet().removeIf(entry -> !entry.getKey().startsWith("ext"));
            map.putAll(extValue);
        }
        //jira-1572 租户是否开启非增票权限校验
        final String checkNVatPermissionValue = configSettingsService.select(tenantId, ConfigSettings.IS_CHECK_N_VAT_PERMISSION.code(), String.class, YesNo._0.getCode());
        map.put("is_check_n_vat_permission", checkNVatPermissionValue);
        return CommonResponse.ok("成功", map);
    }

}