package com.xforceplus.elephant.image.controller.compare.ticket.process;

import static com.xforceplus.elephant.image.core.business.consts.Constants.TENANT_CODE;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.elephant.basecommon.help.BeanUtils;
import com.xforceplus.elephant.basecommon.help.StringHelp;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.system.paas.VerifyUtils;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.ReVerifyRequest;
import com.xforceplus.elephant.image.core.business.config.queue.MQUtils;
import com.xforceplus.elephant.image.core.business.enums.MQEnum;
import com.xforceplus.elephant.image.core.business.util.PlainEntityServiceWrapper;
import com.xforceplus.elephant.image.core.domain.compare.bill.CompareBaseBillService;
import com.xforceplus.elephant.image.core.domain.compare.ticket.CompareTicketService;
import com.xforceplus.elephant.image.core.domain.operationlog.OperationLogService;
import com.xforceplus.elephant.image.core.facade.application.collect.ticket.TicketDetailFacade;
import com.xforceplus.elephant.image.core.util.RequestBuilder;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BillDataStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.OperationEntity;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.OperationType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.BaseBill;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import com.xforceplus.ultraman.metadata.domain.vo.DataCollection;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionOp;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CompareReVerifyProcess extends AbstractProcess<ReVerifyRequest, Boolean> {

    @Autowired
    private PlainEntityServiceWrapper entityService;
    @Autowired
    private TicketDetailFacade ticketDetailFacade;
    @Autowired
    private VerifyUtils verifyUtils;
    @Autowired
    private CompareBaseBillService baseBillService;
    @Autowired
    private MQUtils rabbitmqUtils;
    @Autowired
    private OperationLogService operationLogService;
    @Autowired
    private CompareTicketService ticketService;

    @Override
    protected CommonResponse<Boolean> process(ReVerifyRequest request) throws RuntimeException {
        final IAuthorizedUser user = UserInfoHolder.get();
        final RequestBuilder build = new RequestBuilder()
            .field("tenant_id", ConditionOp.eq, user.getTenantId())
            .field("check_status", ConditionOp.eq, 2)
            .field("check_request_time", ConditionOp.gt_le, request.getCheckRequestTime());
        if (request.getType().toString().equals("1")) {
            build.field("bill_code", ConditionOp.exists);
        }
        if (request.getType().toString().equals("2")) {
            build.field("bill_code", ConditionOp.exists);
        }
        final ConditionQueryRequest queryRequest = build.build();
        final DataCollection<Map<String, Object>> either = entityService.findByCondition(request.getTicketCode(), queryRequest);
        if (either == null) {
            return CommonResponse.failed("查询数据空");
        }
        if (request.getHandle().toString().equals("1")) {
            return saveDetail(either, request, user);
        }
        if (request.getHandle().toString().equals("2")) {
            return send(either, request, user);
        }
        return CommonResponse.failed("错误类型");
    }

    private CommonResponse<Boolean> saveDetail(DataCollection<Map<String, Object>> either, ReVerifyRequest request, IAuthorizedUser user) {
        either.getRows().stream().forEach(r -> {
            //查询明细
            final Long ticketId = Long.valueOf(r.get("id").toString());
            final Integer count = ticketDetailFacade.countTicketDetail(ticketId, request.getTicketCode());
            if (count > 0) {
                return;
            }
            final String verifyResult = verifyUtils.getVerifyResult(user.getTenantId(), r.get("check_task_id").toString());
            if (null == verifyResult) {
                return;
            }
            final JSONObject jsonObject = JSONObject.parseObject(verifyResult);
            if (null == jsonObject || jsonObject.getString("code") == null) {
                return;
            }
            final String result = jsonObject.getString("result");
            if (ValidatorUtil.isEmpty(result)) {
                return;
            }
            insertTicketDetail(request.getTicketCode(), ticketId, result);
        });
        return CommonResponse.ok("插入明细成功");
    }

    private void insertTicketDetail(String ticketCode, Long ticketId, String result) {
        final Integer countDetail = ticketDetailFacade.countTicketDetail(ticketId, ticketCode);
        //明细entityCode不存在
        if (null == countDetail) {
            return;
        }
        final JSONObject jsonObject = JSONObject.parseObject(result);
        //查询明细,存在则不收
        if (countDetail > 0 || ValidatorUtil.isEmpty(jsonObject) || ValidatorUtil.isEmpty(jsonObject.get("invoiceDetails"))) {
            return;
        }
        final JSONArray jsonArray = jsonObject.getJSONArray("invoiceDetails");
        if (null == jsonArray) {
            return;
        }
        final List<String> taxRateList = Lists.newArrayList();
        for (int i = 0; i < jsonArray.size(); i++) {
            final JSONObject object = jsonArray.getJSONObject(i);
            final JSONObject temp = new JSONObject();
            object.entrySet().stream().filter(r -> ValidatorUtil.isNotEmpty(r.getValue())).forEach(r -> temp.put(r.getKey(), r.getValue()));
            temp.put("ticket_id", ticketId);
            final Long detailId = ticketDetailFacade.insertTicketDetail(ticketCode, BeanUtils.convertJSON(temp));
            if (null != detailId && ValidatorUtil.isNotEmpty(object.get("taxRate"))) {
                final String taxRate = object.get("taxRate").toString();
                if (!taxRateList.contains(taxRate)) {
                    taxRateList.add(taxRate);
                }
            }
        }
        if (ValidatorUtil.isNotEmpty(taxRateList)) {
            final Map<String, Object> updateMap = Maps.newHashMap();
            updateMap.put(EntityMeta.Ticket.TAX_RATE.code(), taxRateList.stream().collect(Collectors.joining(",")));
            ticketService.updateTicketByParam(ticketId, ticketCode, updateMap);
        }
    }

    private CommonResponse<Boolean> send(DataCollection<Map<String, Object>> either, ReVerifyRequest request, IAuthorizedUser user) {
        if (request.getType().toString().equals("1")) {
            final List<String> billCodeList = either.getRows().stream()
                .map(r -> r.get("bill_code").toString()).distinct().collect(Collectors.toList());
            if (ValidatorUtil.isEmpty(billCodeList)) {
                return CommonResponse.failed("查询数据空");
            }
            final List<BaseBill> billList = baseBillService.selectBillDataByBillCodes(user.getTenantId(), billCodeList);
            if (ValidatorUtil.isEmpty(billList)) {
                return CommonResponse.failed("查询数据空");
            }
            billList.forEach(r -> {
                if (BillDataStatus._0.getCode().equals(r.getBillDataStatus())
                    || BillDataStatus._2.getCode().equals(r.getBillDataStatus())) {
                    return;
                }
                final Map<String, Object> pushMap = Maps.newHashMap();
                pushMap.put("source", "重算");
                pushMap.put("tenantId", user.getTenantId());
                pushMap.put("billCode", r.getBillCode());
                pushMap.put("billTypeCode", r.getBillTypeCode());
                final Map<String, Object> headers = new HashMap<>();
                headers.put(TENANT_CODE, user.getTenantCode());
                rabbitmqUtils.sendByDirectExchange(MQEnum.RE_CHECK_BILL_TICKET_QUEUE, pushMap, headers);
                operationLogService.insertOperationLog(OperationEntity.BILL.getCode(), r.getBillCode(),
                    OperationType.RE_CHECK_BILL.getCode(), user.getUsername(), "");
            });
            return CommonResponse.ok("下发单据成功");
        }
        if (request.getType().toString().equals("2")) {
            either.getRows().stream().forEach(r -> {
                if (r.get("commit_status").toString().equals("0")) {
                    return;
                }
                final Map<String, Object> paramMap = Maps.newHashMap();
                paramMap.put("tenantId", user.getTenantId());
                paramMap.put("imageId", Long.valueOf(r.get("image_id").toString()));
                final Map<String, Object> headers = new HashMap<>();
                headers.put(TENANT_CODE, user.getTenantCode());
                rabbitmqUtils.sendByDirectExchange(MQEnum.SYNC_TICKET_QUEUE, paramMap, headers);
                final Long ticketId = Long.valueOf(r.get("id").toString());
                operationLogService.insertOperationLog(OperationEntity.TICKET.getCode(), StringHelp.safeToString(ticketId), OperationType.PUSH_TICKET.getCode(),
                    user.getUsername(), "");
            });
            return CommonResponse.ok("下发单证成功");
        }
        return CommonResponse.failed("错误类型");
    }

}
