package com.xforceplus.elephant.image.controller.compare.ticket.process.submit;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.annotation.Dispatch;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.SubmitTicketRequest;
import com.xforceplus.elephant.image.core.facade.application.calculate.commit.TicketCommitFacade;
import com.xforceplus.elephant.image.core.facade.dto.commit.TicketCommitDto;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @Description: 单证提交默认process类
 * @Author liming
 * @Date 2020/8/20 15:23
 */
@Dispatch(isDefault = true)
@Service
public class DefaultCompareSubmitTicketProcess extends AbstractProcess<SubmitTicketRequest, JSONObject> {

    @Autowired
    private TicketCommitFacade ticketCommitFacade;

    @Override
    protected void check(SubmitTicketRequest request) throws ValidationException {
        super.check(request);
        if (ValidatorUtil.isEmpty(request.getImageIds())) {
            throw new ValidationException("请先勾选单据");
        }
    }

    @Override
    protected CommonResponse<JSONObject> process(SubmitTicketRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        logger.info("提交发票请求,tenantId:{},tenantCode:{},ids:{}", authorizedUser.getTenantId(), authorizedUser.getTenantCode(), request.getImageIds());
        ticketCommitFacade.commitTicket(TicketCommitDto.builder()
            .tenantId(authorizedUser.getTenantId())
            .userId(authorizedUser.getId())
            .userName(authorizedUser.getUsername())
            .imageIds(request.getImageIds())
            .backRemark(request.getBackRemark())
            .type(request.getType())
            .ticketEntityCode(EntityMeta.CompareTicket.code())
            .imageEntityCode(EntityMeta.CompareImage.code())
            .build());
        return CommonResponse.ok("提交发票成功", null);
    }

}
