package com.xforceplus.elephant.image.controller.logmq.process;

import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.HandleMessageRequest;
import com.xforceplus.elephant.image.core.business.config.queue.MQUtils;
import com.xforceplus.elephant.image.core.business.enums.MQEnum;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeleteMessageProcess extends AbstractProcess<HandleMessageRequest, Boolean> {

    @Autowired
    private MQUtils rabbitmqUtils;

    @Override
    protected void check(HandleMessageRequest request) throws ValidationException {
        super.check(request);
        if (ValidatorUtil.isEmpty(request.getIndexId())) {
            throw new ValidationException("消息下标【indexId】不能为空");
        }
    }

    @Override
    protected CommonResponse<Boolean> process(HandleMessageRequest request) throws RuntimeException {
        rabbitmqUtils.handleMessage(request.getIndexId(), MQEnum.IMAGE_DEAD_LETTER_QUEUE, "", "", "", null, false);
        return CommonResponse.ok("删除成功");
    }

}