package com.xforceplus.elephant.image.controller.ticket.process;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.enums.bill.ExtStatusEnum;
import com.xforceplus.elephant.basecommon.help.NameUtils;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.BackNonInvoiceRequest;
import com.xforceplus.elephant.image.core.business.application.collect.image.service.ImageService;
import com.xforceplus.elephant.image.core.business.application.collect.ticket.service.TicketService;
import com.xforceplus.elephant.image.core.expand.BillImageTicketService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BackStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.BackType;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.CommitStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.dict.ExtStatus;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Image;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Ticket;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.springframework.stereotype.Service;

@Slf4j
@Service
@RequiredArgsConstructor
public class BackNonInvoiceProcess extends AbstractProcess<BackNonInvoiceRequest, Boolean> {

    private final TicketService ticketService;
    private final ImageService imageService;
    private final BillImageTicketService billImageTicketService;

    @Override
    protected void check(BackNonInvoiceRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getTicketIds(), "单证ID集合【ticketIds】不能为空");
    }

    @Override
    protected CommonResponse<Boolean> process(BackNonInvoiceRequest request) throws RuntimeException {
        final IAuthorizedUser user = UserInfoHolder.get();
        final List<Ticket> tickets = ticketService.selectTicketListByIds(user.getTenantId(), request.getTicketIds());
        if (CollectionUtils.isEmpty(tickets)) {
            return CommonResponse.failed("未查询到数据");
        }

        //仅退回
        if (ExtStatus._1.getCode().equals(request.getStatus())) {
            final List<Long> ids = tickets.stream().map(Ticket::getId).collect(Collectors.toList());
            final Map<String, Object> updateMap = new HashMap<>();
            updateMap.put(EntityMeta.Ticket.COMMIT_STATUS.code(), CommitStatus._0.getCode());
            updateMap.put(EntityMeta.Ticket.BACK_STATUS.code(), BackStatus._1.getCode());
            updateMap.put(EntityMeta.Ticket.BACK_TIME.code(), System.currentTimeMillis());
            ticketService.updateMulti(ids, updateMap, EntityMeta.Ticket.code());
            final List<Long> imageIds = tickets.stream().map(Ticket::getImageId).collect(Collectors.toList());
            //退回下发
            billImageTicketService.syncTicket(user.getTenantId(), imageIds, false, map -> {
                final JSONObject invoiceMain = (JSONObject) MapUtils.getObject(map, "invoiceMain");
                if (invoiceMain != null) {
                    invoiceMain.put(NameUtils.firstLowerName(EntityMeta.Ticket.BACK_TYPE.code()), BackType._1.getCode());
                    invoiceMain.put(NameUtils.firstLowerName(EntityMeta.Ticket.TICKET_STATUS.code()), Integer.toString(ExtStatusEnum.DELETE_SUCCESS.getCode()));
                }
            });
            return CommonResponse.ok("退回成功");
        }

        //规则过滤出可删除的发票
        final Map<String, List<Long>> resultMap = billImageTicketService.deleteTicketData(user.getTenantId(), request.getTicketIds(), EntityMeta.Ticket.code());
        final List<Long> imageIds = resultMap.get("imageIds");
        final List<Long> ticketIds = resultMap.get("ticketIds");
        if (CollectionUtils.isEmpty(ticketIds)) {
            return CommonResponse.failed("没有找到可操作的数据");
        }
        //查询发票下挂接的附件，然后一并删除
        if (CollectionUtils.isNotEmpty(imageIds)) {
            final List<Long> attachmentAndSalesImageId = imageService.selectTicketAttachmentAndSalesList(user.getTenantId(), imageIds, EntityMeta.Image.code()).stream().map(Image::getId)
                .collect(Collectors.toList());
            imageIds.addAll(attachmentAndSalesImageId);
        }
        if (ValidatorUtil.isEmpty(imageIds)) {
            return CommonResponse.failed("没有找到可操作的数据");
        }
        //删除下发操作
        billImageTicketService.syncTicket(user.getTenantId(), imageIds, false, map -> {
            final JSONObject invoiceMain = (JSONObject) MapUtils.getObject(map, "invoiceMain");
            if (invoiceMain != null) {
                invoiceMain.put(NameUtils.firstLowerName(EntityMeta.Ticket.BACK_TYPE.code()), BackType._1.getCode());
                invoiceMain.put(NameUtils.firstLowerName(EntityMeta.Ticket.TICKET_STATUS.code()), Integer.toString(ExtStatusEnum.DELETE_SUCCESS.getCode()));
            }
        });
        //删除
        final boolean result = billImageTicketService.deleteImageAndTicketByImageIds(user.getTenantId(), imageIds);
        if (result) {
            String message = "删除成功";
            if (request.getTicketIds().size() != ticketIds.size()) {
                message = String.format("%d条记录成功删除%d条", request.getTicketIds().size(), ticketIds.size());
            }
            return CommonResponse.ok(message, true);
        } else {
            return CommonResponse.failed("无记录删除");
        }
    }

}