package com.xforceplus.elephant.image.controller.ticket.process;

import com.xforceplus.elephant.basecommon.exception.ElephantException;
import com.xforceplus.elephant.basecommon.process.AbstractProcess;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.client.model.SubmitCancelRequest;
import com.xforceplus.elephant.image.core.facade.application.calculate.commit.TicketCommitFacade;
import com.xforceplus.elephant.image.core.facade.application.collect.ticket.TicketFacade;
import com.xforceplus.elephant.image.core.facade.dto.commit.SubmitCancelResponseDto;
import com.xforceplus.elephant.image.core.facade.dto.commit.TicketCommitDto;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.entity.Ticket;
import java.util.List;
import javax.validation.ValidationException;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

/**
 * 单证撤销process类
 * @author rongying
 * @date 2022/6/30 16:27
 */
@RequiredArgsConstructor
@Service
public class SubmitCancelProcess extends AbstractProcess<SubmitCancelRequest, SubmitCancelResponseDto> {

    private final TicketFacade ticketFacade;
    private final TicketCommitFacade ticketCommitFacade;

    @Override
    protected void check(SubmitCancelRequest request) throws ValidationException {
        super.check(request);
        checkEmpty(request.getTicketIds(), "发票参数不能为空");
    }

    @Override
    protected CommonResponse<SubmitCancelResponseDto> process(SubmitCancelRequest request) throws RuntimeException {
        final IAuthorizedUser authorizedUser = UserInfoHolder.get();
        if (null == authorizedUser) {
            throw new ValidationException("获取用户信息为空，请重新登陆");
        }
        final List<Ticket> ticketList = ticketFacade.selectTicketListByIds(authorizedUser.getTenantId(), request.getTicketIds());
        if (ValidatorUtil.isEmpty(ticketList)) {
            throw new ElephantException("没有找到可操作的数据.");
        }
        final SubmitCancelResponseDto responseDto = ticketCommitFacade.commitCancel(TicketCommitDto.builder()
            .tenantId(authorizedUser.getTenantId())
            .userId(authorizedUser.getId())
            .userName(authorizedUser.getUsername())
            .userCode(authorizedUser.getUserCode())
            .ticketList(ticketList)
            .build());
        if (ValidatorUtil.isNotEmpty(responseDto.getMessage())) {
            return CommonResponse.from(CommonResponse.Fail, responseDto.getMessage(), responseDto);
        }
        return CommonResponse.ok("发送撤销成功", responseDto);
    }

}
