package com.xforceplus.elephant.image.listener;

import com.rabbitmq.client.AMQP.Queue.DeclareOk;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.beans.factory.annotation.Value;

@Slf4j
public class MqQueueSizeListener {

    public static final Map<String, Integer> QUEUE_SIZE = new HashMap<>();

    @Value("${image.mq.sizeListener.queues:image_imagePdfTransFormCallbackQueue_v2}")
    private List<String> queues;
    private final Channel channel;

    public MqQueueSizeListener(CachingConnectionFactory connectionFactory) {
        channel = connectionFactory.createConnection().createChannel(false);
    }

    //@Scheduled(cron = "${image.mq.sizeListener.cron:0/30 * 8-18 * * ?}")
    public void size() {
        for (String queue : queues) {
            try {
                final DeclareOk declareOk = channel.queueDeclarePassive(queue);
                final int queueSize = declareOk.getMessageCount();
                QUEUE_SIZE.put(queue, queueSize);
                log.info("queue:{} size:{}", queue, queueSize);
            } catch (IOException e) {
                log.error("获取队列长度失败", e);
            }
        }
    }

}
