package com.xforceplus.elephant.image.servicehandler.export;

import akka.NotUsed;
import akka.stream.javadsl.Source;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.elephant.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.elephant.image.core.facade.application.config.dictionary.DictionaryFacade;
import com.xforceplus.elephant.image.core.util.ImageOrgUtils;
import com.xforceplus.elephant.image.core.util.RequestParser;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.ultraman.app.imageservicesaas.metadata.meta.EntityMeta;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionOp;
import com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionQueryRequest;
import com.xforceplus.ultraman.metadata.entity.IEntityClass;
import com.xforceplus.ultraman.sdk.core.bulk.exporter.ClassifiedRecord;
import com.xforceplus.ultraman.sdk.core.bulk.exporter.ExportSource;
import com.xforceplus.ultraman.sdk.core.bulk.exporter.impl.SequenceExportSource;
import com.xforceplus.ultraman.sdk.core.facade.EntityFacade;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpFactory;
import com.xforceplus.ultraman.sdk.core.rel.legacy.ExpRel;
import com.xforceplus.ultraman.starter.autoconfigure.SdkConfiguration;
import io.vavr.Tuple2;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

/**
 * 单据导出二开
 *
 * @author rongying
 * @date 2021/6/7 17:48
 */
@Component
public class TicketExportSource implements ExportSource {

    private SequenceExportSource source;

    private final EntityFacade entityFacade;

    private final ContextService contextService;

    private final SdkConfiguration sdkConfiguration;

    private final DictionaryFacade dictionaryFacade;

    private final ImageOrgUtils imageOrgUtils;

    public TicketExportSource(EntityFacade entityFacade, ContextService contextService, SdkConfiguration sdkConfiguration,
        DictionaryFacade dictionaryFacade, ImageOrgUtils imageOrgUtils) {
        this.entityFacade = entityFacade;
        this.contextService = contextService;
        this.sdkConfiguration = sdkConfiguration;
        this.dictionaryFacade = dictionaryFacade;
        this.imageOrgUtils = imageOrgUtils;
        source = new SequenceExportSource(entityFacade, 1000, 3, contextService, sdkConfiguration.getExec());
    }

    @Override
    public boolean isAccept(IEntityClass iEntityClass, boolean isMultiSchema, Map<String, Object> map) {
        return !isMultiSchema && (iEntityClass.code().equals(EntityMeta.Ticket.code()) || (iEntityClass.extendEntityClass() != null && iEntityClass.extendEntityClass().code()
            .equals(EntityMeta.Ticket.code())));
    }

    @Override
    public int getOrder() {
        return Ordered.HIGHEST_PRECEDENCE;
    }

    @Override
    public Source<ClassifiedRecord, NotUsed> source(String classifier, IEntityClass iEntityClass, ExpRel query, Map<String, ExpRel> subQuery, long maxRecord, Map<String, Object> context) {
        //获取页面pageCode
        final String pageCode = (String) context.get("PAGE");
        //获取二开条件
        final ExpRel newExpQuery = getNewQuery(query, UserInfoHolder.get(), pageCode);
        if (null == newExpQuery) {
            return Source.empty();
        }
        //查询返回
        return source.source(Optional.ofNullable(classifier).orElse(iEntityClass.code()), iEntityClass, newExpQuery, subQuery, maxRecord, context).map(record -> {
            final Map<String, Object> recordMap = record.getRecord().toMap(Collections.emptySet());
            final JSONObject invoice = new JSONObject(recordMap);
            final String ticketCode = invoice.getString(EntityMeta.Ticket.TICKET_CODE.code());
            final double amountWithTax = invoice.getDoubleValue(EntityMeta.Ticket.AMOUNT_WITH_TAX.code());
            if (EntityMeta.TicketTrain.code().equals(ticketCode)) {
                final String taxAmount = new BigDecimal(amountWithTax / 1.09 * 0.09).setScale(2, BigDecimal.ROUND_HALF_UP).toString();
                record.getRecord().set(EntityMeta.Ticket.TAX_AMOUNT.code(), taxAmount);
            } else if (EntityMeta.TicketBus.code().equals(ticketCode)) {
                final String taxAmount = new BigDecimal(amountWithTax / 1.03 * 0.03).setScale(2, BigDecimal.ROUND_HALF_UP).toString();
                record.getRecord().set(EntityMeta.Ticket.TAX_AMOUNT.code(), taxAmount);
            } else if (EntityMeta.TicketPlane.code().equals(ticketCode)) {
                final double fare = invoice.getDoubleValue(EntityMeta.TicketPlane.FARE.code());
                final double fuelSurcharge = invoice.getDoubleValue(EntityMeta.TicketPlane.FUEL_SURCHARGE.code());
                final String taxAmount = new BigDecimal((fare + fuelSurcharge) / 1.09 * 0.09).setScale(2, BigDecimal.ROUND_HALF_UP).toString();
                record.getRecord().set(EntityMeta.Ticket.TAX_AMOUNT.code(), taxAmount);
            }
            return record;
        });
    }

    @Override
    public int compareTo(ExportSource o) {
        return 0;
    }

    /**
     * 获取二开条件
     * JXCPX-1320 数据字典配置页面，租户开启组织查询
     * @author rongying
     * @date 2022/2/17 11:37
     * @param authorizedUser 用户
     * @param pageCode 页面代码
     * @return com.xforceplus.ultraman.metadata.domain.vo.dto.ConditionQueryRequest
     */
    private ExpRel getNewQuery(ExpRel query, IAuthorizedUser authorizedUser, String pageCode) {
        //JXCPX-1320 数据字典配置页面，租户开启组织查询
        //没有开权限查询，返回原筛选条件查询
        //获取二开条件
        final ToConditionQueryRequest toConditionQueryRequest = new ToConditionQueryRequest();
        query.accept(toConditionQueryRequest);
        final ConditionQueryRequest request = toConditionQueryRequest.getConditionQueryRequest();
        final RequestParser requestParser = RequestParser.parse(request);
        requestParser.removeField("page_code");
        if (dictionaryFacade.isOpenOrgQuery(pageCode, authorizedUser.getTenantId(), authorizedUser.getTenantCode())) {
            final Tuple2<Boolean, List<Long>> tuple = imageOrgUtils.getCurrentUserOrgIds(authorizedUser.getTenantId(), authorizedUser.getId());
            //拥有全部，不添加此限制
            if (Boolean.TRUE.equals(tuple._1)) {
                query.getFilters().clear();
                query.getFilters().addAll(ExpFactory.createFrom(request).getFilters());
                return query;
            }
            //组织为空，无权限，返回空数据
            final List<Long> orgIds = tuple._2;
            if (ValidatorUtil.isEmpty(orgIds)) {
                return null;
            }
            requestParser.field("org_id", ConditionOp.in, orgIds);
        }
        //用户筛选的区域权限
        if (ValidatorUtil.isNotEmpty(requestParser.subValue("areas", EntityMeta.Ticket.ID.code()))) {
            final List<String> values = requestParser.subValue("areas", EntityMeta.Ticket.ID.code());
            requestParser.removeSubField("areas", EntityMeta.Ticket.ID.code());
            requestParser.field(EntityMeta.Ticket.AREA_ID.code(), ConditionOp.in, values);
        }
        if (ValidatorUtil.isNotEmpty(requestParser.subValue("area", EntityMeta.Ticket.ID.code()))) {
            final List<String> values = requestParser.subValue("area", EntityMeta.Ticket.ID.code());
            requestParser.removeSubField("area", EntityMeta.Ticket.ID.code());
            requestParser.field(EntityMeta.Ticket.AREA_ID.code(), ConditionOp.in, values);
        }
        //默认区域权限
        if (dictionaryFacade.isOpenAreaQuery(pageCode, authorizedUser.getTenantId(), authorizedUser.getTenantCode())) {
            final Tuple2<Boolean, List<Long>> tuple = imageOrgUtils.getCurrentUserOrgIds(authorizedUser.getTenantId(), authorizedUser.getId());
            //拥有全部，不添加此限制
            if (Boolean.TRUE.equals(tuple._1)) {
                return query;
            }
            //组织为空，无权限，返回空数据
            final List<Long> orgIds = tuple._2;
            if (ValidatorUtil.isEmpty(orgIds)) {
                return null;
            }
            requestParser.field(EntityMeta.Ticket.AREA_ID.code(), ConditionOp.in, orgIds);
        }
        //合并至原query请求
        query.getFilters().clear();
        query.getFilters().addAll(ExpFactory.createFrom(request).getFilters());
        return query;
    }

}
