package com.xforceplus.elephant.image.client.api;

import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.BackBaseBillRequest;
import com.xforceplus.elephant.image.client.model.BaseBillCommitRequest;
import com.xforceplus.elephant.image.client.model.BaseBillDeleteRequest;
import com.xforceplus.elephant.image.client.model.BatchDownloadImageRequest;
import com.xforceplus.elephant.image.client.model.DownloadImageRequest;
import com.xforceplus.elephant.image.client.model.GetBaseBillDetailRequest;
import com.xforceplus.elephant.image.client.model.GetBillTypeListRequest;
import com.xforceplus.elephant.image.client.model.GetCountInfoRequest;
import com.xforceplus.elephant.image.client.model.GetDetailResourceCodeRequest;
import com.xforceplus.elephant.image.client.model.GetListResourceCodeRequest;
import com.xforceplus.elephant.image.client.model.GetTicketListRequest;
import com.xforceplus.elephant.image.client.model.HangBillRequest;
import com.xforceplus.elephant.image.client.model.HookTicketRequest;
import com.xforceplus.elephant.image.client.model.ReCheckBillRequest;
import com.xforceplus.elephant.image.client.model.SplitBillRequest;
import com.xforceplus.elephant.image.client.model.UpdateVerifyStatusRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


@Api(value = "baseBill", description = "the baseBill API", tags = "baseBill")
public interface BaseBillApi {

    @ApiOperation(value = "单据批量提交", notes = "", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/baseBill/commit",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse commit(@ApiParam(value = "request", required = true) @Valid BaseBillCommitRequest request
    );


    @ApiOperation(value = "单据批量删除", notes = "", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/baseBill/delete",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse delete(@ApiParam(value = "request", required = true) @Valid BaseBillDeleteRequest request
    );


    @ApiOperation(value = "单据详情全部下载影像", notes = "单据详情全部下载影像", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/baseBill/downloadImage",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse downloadImage(@ApiParam(value = "request", required = true) @Valid DownloadImageRequest request
    );


    @ApiOperation(value = "根据单据号批量下载影像", notes = "根据单据号批量下载影像", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/baseBill/downloadImageByBillNo",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse downloadImageByBillNo(@ApiParam(value = "request", required = true) @Valid BatchDownloadImageRequest request
    );

    @ApiOperation(value = "获取单据详情详情", notes = "", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/baseBill/getBaseBillDetail",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getBaseBillDetail(@ApiParam(value = "request", required = true) @Valid GetBaseBillDetailRequest request
    );


    @ApiOperation(value = "获取单据号", notes = "", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/baseBill/getBillCode/{keyCode}",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getBillCode(@ApiParam(value = "", required = true) @PathVariable("keyCode") String keyCode
        , @ApiParam(value = "request", required = true) @Valid BaseRequest request
    );


    @ApiOperation(value = "获取单据类型集合", notes = "获取单据类型集合", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "数据列表")})
    @RequestMapping(value = "/baseBill/getBillTypeList",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getBillTypeList(@ApiParam(value = "request", required = true) @Valid GetBillTypeListRequest request
    );


    @ApiOperation(value = "获取单据数量", notes = "获取单据数量", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/baseBill/countInfo",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getCountInfo(@ApiParam(value = "request", required = true) @Valid GetCountInfoRequest request
    );


    @ApiOperation(value = "获取单据详情资源码", notes = "", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/baseBill/getDetailResourceCode",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getDetailResourceCode(@ApiParam(value = "request", required = true) @Valid GetDetailResourceCodeRequest request
    );

    @ApiOperation(value = "获取单据列表资源码", notes = "", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/baseBill/getListResourceCode",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getListResourceCode(@ApiParam(value = "request", required = true) @Valid GetListResourceCodeRequest request
    );


    @ApiOperation(value = "获取单证List", notes = "", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/baseBill/getTicketList",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getTicketList(@ApiParam(value = "request", required = true) @Valid GetTicketListRequest request
    );


    @ApiOperation(value = "单据挂起", notes = "单据挂起", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/baseBill/hangBill",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse hangBill(@ApiParam(value = "request", required = true) @Valid HangBillRequest request
    );


    @ApiOperation(value = "单据认领单证", notes = "单据认领单证", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/baseBill/hookTicket",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse hookTicket(@ApiParam(value = "request", required = true) @Valid HookTicketRequest request
    );


    @ApiOperation(value = "获取当前用户所属组织包含的单据字段（组合）", notes = "获取当前用户所属组织包含的单据字段（组合）", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "结果")})
    @RequestMapping(value = "/baseBill/orgExtensions",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse orgExtensions(@ApiParam(value = "request", required = true) @Valid BaseRequest request
    );


    @ApiOperation(value = "代办退回单据", notes = "代办退回单据", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/baseBill/pendingBack",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse pendingBackBaseBill(@ApiParam(value = "request", required = true) @Valid BackBaseBillRequest request
    );


    @ApiOperation(value = "重算单据", notes = "重算单据", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/baseBill/reCheckBill",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse reCheckBill(@ApiParam(value = "request", required = true) @Valid ReCheckBillRequest request
    );


    @ApiOperation(value = "拆单", notes = "", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/baseBill/split",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse split(@ApiParam(value = "request", required = true) @Valid SplitBillRequest request
    );


    @ApiOperation(value = "更新核验签收状态", notes = "更新核验签收状态", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/baseBill/updateVerifyStatus",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse updateVerifyStatus(@ApiParam(value = "request", required = true) @Valid UpdateVerifyStatusRequest request
    );

    @ApiOperation(value = "运维单据删除", notes = "运维单据删除", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/baseBill/operationDelete",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse operationDelete(@ApiParam(value = "request", required = true) @Valid BaseBillDeleteRequest request);

}
