package com.xforceplus.elephant.image.client.api;

import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.BillSelectAllRequest;
import com.xforceplus.elephant.image.client.model.CancelReturnImageRequest;
import com.xforceplus.elephant.image.client.model.CountRecStatusRequest;
import com.xforceplus.elephant.image.client.model.CutImageRequest;
import com.xforceplus.elephant.image.client.model.DownloadImageFileRequest;
import com.xforceplus.elephant.image.client.model.GetCoverImageListRequest;
import com.xforceplus.elephant.image.client.model.GetImageListRequest;
import com.xforceplus.elephant.image.client.model.GetImageReturnListRequest;
import com.xforceplus.elephant.image.client.model.GetImageStreamRequest;
import com.xforceplus.elephant.image.client.model.InsertBillImageRequest;
import com.xforceplus.elephant.image.client.model.InsertImageRequest;
import com.xforceplus.elephant.image.client.model.MoveImageRequest;
import com.xforceplus.elephant.image.client.model.ReturnImageRequest;
import com.xforceplus.elephant.image.client.model.RotateImageRequest;
import com.xforceplus.elephant.image.client.model.SaveImageOrCopyRequest;
import com.xforceplus.elephant.image.client.model.SaveImageRequest;
import com.xforceplus.elephant.image.client.model.SourceFileUploadRequest;
import com.xforceplus.elephant.image.client.model.UpdateImageRequest;
import com.xforceplus.elephant.image.client.model.UploadRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.concurrent.ExecutionException;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


@Api(value = "image", description = "the image API", tags = "image")
public interface ImageApi {

    @ApiOperation(value = "标记影像取消退回", notes = "标记影像取消退回", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "结果")})
    @RequestMapping(value = "/image/cancelReturn",
        produces = {"application/json"},
        method = RequestMethod.PUT)
    CommonResponse cancelReturnImage(@ApiParam(value = "request", required = true) @Valid CancelReturnImageRequest request
    );


    @ApiOperation(value = "获取影像各维度识别状态分组统计数", notes = "获取影像各维度识别状态分组统计数", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "数据列表")})
    @RequestMapping(value = "/image/countRecStatus",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse countRecStatus(@ApiParam(value = "request", required = true) @Valid CountRecStatusRequest request
    ) throws ExecutionException;


    @ApiOperation(value = "删除影像表信息", notes = "删除影像表信息", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "删除结果")})
    @RequestMapping(value = "/image",
        produces = {"application/json"},
        method = RequestMethod.DELETE)
    CommonResponse deleteImage(@ApiParam(value = "request", required = true) @Valid BillSelectAllRequest request
    );


    @ApiOperation(value = "单据详情下载影像源文件", notes = "", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/image/downloadImageFile",
        produces = {"application/octet-stream"},
        method = RequestMethod.GET)
    Object downloadImageFile(@ApiParam(value = "request", required = true) @Valid DownloadImageFileRequest request
    );


    @ApiOperation(value = "获取影像表详情", notes = "", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/image/{imageId:[0-9]+}",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getImageDetail(@ApiParam(value = "自增主键", required = true) @PathVariable("imageId") Long imageId
        , @ApiParam(value = "request", required = true) @Valid BaseRequest request
    );


    @ApiOperation(value = "获取影像表输出流", notes = "", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/image/{imageId:[0-9]+}.{fileExt}",
        produces = {"application/octet-stream"},
        method = RequestMethod.GET)
    Object getImageFile(@ApiParam(value = "主键", required = true) @PathVariable("imageId") Long imageId
        , @ApiParam(value = "文件类型", required = true) @PathVariable("fileExt") String fileExt
        , @ApiParam(value = "request", required = true) @Valid GetImageStreamRequest request
    );


    @ApiOperation(value = "获取影像表列表", notes = "获取影像表数据", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "数据列表")})
    @RequestMapping(value = "/image",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getImageList(@ApiParam(value = "request", required = true) @Valid GetImageListRequest request);

    @ApiOperation(value = "获取影像表列表", notes = "获取影像表数据", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "数据列表")})
    @RequestMapping(value = "/image/list",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse getImageListPost(@ApiParam(value = "request", required = true) @Valid GetImageListRequest request);


    @ApiOperation(value = "获取影像退回列表", notes = "获取影像退回数据", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "数据列表")})
    @RequestMapping(value = "/image/return",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getImageReturnList(@ApiParam(value = "request", required = true) @Valid GetImageReturnListRequest request
    );


    @ApiOperation(value = "获取影像表输出流", notes = "", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/image/{imageId}/stream",
        produces = {"application/octet-stream"},
        method = RequestMethod.GET)
    Object getImageStream(@ApiParam(value = "主键", required = true) @PathVariable("imageId") Long imageId
        , @ApiParam(value = "request", required = true) @Valid GetImageStreamRequest request
    );


    @ApiOperation(value = "补扫影像表", notes = "补扫影像表", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "新增结果")})
    @RequestMapping(value = "/image/insert",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse insertImage(@ApiParam(value = "request", required = true) @Valid InsertImageRequest request
    );


    @ApiOperation(value = "移动影像", notes = "移动影像", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "结果")})
    @RequestMapping(value = "/image/{imageId}/move",
        produces = {"application/json"},
        method = RequestMethod.PUT)
    CommonResponse moveImage(@ApiParam(value = "自增主键", required = true) @PathVariable("imageId") Long imageId
        , @ApiParam(value = "request", required = true) @Valid MoveImageRequest request
    );


    @ApiOperation(value = "个人影像新增", notes = "个人影像新增", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "新增结果")})
    @RequestMapping(value = "/image/person",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse personSave(@ApiParam(value = "request", required = true) @Valid SaveImageRequest request
    );


    @ApiOperation(value = "封面替扫", notes = "封面替扫", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "撤销结果")})
    @RequestMapping(value = "/image/{billCode}/cover",
        produces = {"application/json"},
        method = RequestMethod.PUT)
    CommonResponse replaceCoverImage(@ApiParam(value = "request", required = true) @Valid UpdateImageRequest request
    );


    @ApiOperation(value = "撤销影像覆盖", notes = "撤销影像覆盖", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "撤销结果")})
    @RequestMapping(value = "/image/{imageId}/reset",
        produces = {"application/json"},
        method = RequestMethod.PUT)
    CommonResponse resetImage(@ApiParam(value = "自增主键", required = true) @PathVariable("imageId") Long imageId
        , @ApiParam(value = "request", required = true) @Valid BaseRequest request
    );


    @ApiOperation(value = "标记影像为退回状态", notes = "标记影像为退回状态", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "结果")})
    @RequestMapping(value = "/image/return",
        produces = {"application/json"},
        method = RequestMethod.PUT)
    CommonResponse returnImage(@ApiParam(value = "request", required = true) @Valid ReturnImageRequest request
    );


    @ApiOperation(value = "旋转影像", notes = "旋转影像", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "撤销结果")})
    @RequestMapping(value = "/image/{imageId}/rotateImage",
        produces = {"application/json"},
        method = RequestMethod.PUT)
    CommonResponse rotateImage(@ApiParam(value = "自增主键", required = true) @PathVariable("imageId") Long imageId
        , @ApiParam(value = "request", required = true) @Valid RotateImageRequest request
    );


    @ApiOperation(value = "新增影像表", notes = "新增影像表", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "新增结果")})
    @RequestMapping(value = "/image",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse saveImage(@ApiParam(value = "request", required = true) @Valid SaveImageRequest request
    );


    @ApiOperation(value = "根据影像ID和base64覆盖影像或创建副本", notes = "根据影像ID和base64覆盖影像或创建副本", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "更新结果")})
    @RequestMapping(value = "/image/{imageId}/base64",
        produces = {"application/json"},
        method = RequestMethod.PUT)
    CommonResponse saveImageOrCopyByBase64(@ApiParam(value = "自增主键", required = true) @PathVariable("imageId") Long imageId
        , @ApiParam(value = "request", required = true) @Valid SaveImageOrCopyRequest request
    );


    @ApiOperation(value = "脱挂影像", notes = "脱挂影像", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "脱挂结果")})
    @RequestMapping(value = "/image/unhook",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse unhookImage(@ApiParam(value = "request", required = true) @Valid BillSelectAllRequest request
    );


    @ApiOperation(value = "上传", notes = "上传", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "上传结果")})
    @RequestMapping(value = "/image/upload",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse upload(@ApiParam(value = "request", required = true) @Valid UploadRequest request
    );


    @ApiOperation(value = "补扫影像", notes = "补扫影像", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "新增结果")})
    @RequestMapping(value = "/image/insertBillImage",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse insertBillImage(@ApiParam(value = "request", required = true) @Valid InsertBillImageRequest request
    );

    @ApiOperation(value = "上传拦截文案", notes = "上传拦截文案", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "文案")})
    @RequestMapping(value = "/image/uploadMessage",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse uploadMessage(@ApiParam(value = "request", required = true) @Valid BaseRequest request
    );

    @ApiOperation("切割影像")
    @PostMapping("/image/cutImage")
    CommonResponse<Long> cutImage(@ApiParam(value = "request", required = true) @RequestBody CutImageRequest request);


    @ApiOperation(value = "重新转换", notes = "重新转换", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "文案")})
    @RequestMapping(value = "/image/reTransfromImage",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse reTransfromImage(@ApiParam(value = "request", required = true) @RequestBody BillSelectAllRequest request
    );

    @ApiOperation(value = "上传附件", notes = "上传附件", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "上传结果")})
    @RequestMapping(value = "/image/uploadAttachment",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse uploadAttachment(@ApiParam(value = "request", required = true) @RequestBody UploadRequest request
    );


    @ApiOperation(value = "源文件上传", notes = "源文件上传", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "源文件上传结果")})
    @RequestMapping(value = "/image/sourceFileUpload",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse sourceFileUpload(@ApiParam(value = "request", required = true) @RequestBody SourceFileUploadRequest request
    );

    @ApiOperation(value = "获取封面影像", notes = "获取封面影像", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "结果")})
    @RequestMapping(value = "/image/getCoverImageList",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getCoverImageList(@ApiParam(value = "request", required = true) @Valid GetCoverImageListRequest request
    );

    @ApiOperation(value = "封面上传", notes = "封面上传", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "撤销结果")})
    @RequestMapping(value = "/image/saveCoverImage",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse saveCoverImage(@ApiParam(value = "request", required = true) @Valid SaveImageRequest request
    );

    @ApiOperation(value = "删除封面影像", notes = "删除封面影像", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "撤销结果")})
    @RequestMapping(value = "/image/{imageId}/deleteCoverImage",
        produces = {"application/json"},
        method = RequestMethod.PUT)
    CommonResponse deleteCoverImage(@ApiParam(value = "自增主键", required = true) @PathVariable("imageId") Long imageId
        , @ApiParam(value = "request", required = true) @Valid BaseRequest request
    );

}
