package com.xforceplus.elephant.image.client.api;

import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.GetLogisticsPostcodeListRequest;
import com.xforceplus.elephant.image.client.model.SaveLogisticsPostcodeRequest;
import com.xforceplus.elephant.image.client.model.UpdateLogisticsPostcodeRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


@Api(value = "logisticsPostcode", description = "the logisticsPostcode API", tags = "logisticsPostcode")
public interface LogisticsPostcodeApi {

    @ApiOperation(value = "删除物流信息", notes = "删除物流信息", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "删除结果")})
    @RequestMapping(value = "/logisticsPostcode/{postcodeId}",
        produces = {"application/json"},
        method = RequestMethod.DELETE)
    CommonResponse deleteLogisticsPostcode(@ApiParam(value = "自增主键", required = true) @PathVariable("logisticsPostcodeId") Long logisticsPostcodeId
        , @ApiParam(value = "request", required = true) @Valid BaseRequest request
    );


    @ApiOperation(value = "获取物流详情", notes = "", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/logisticsPostcode/{postcodeId}",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getLogisticsPostcodeDetail(@ApiParam(value = "自增主键", required = true) @PathVariable("logisticsPostcodeId") Long logisticsPostcodeId
        , @ApiParam(value = "request", required = true) @Valid BaseRequest request
    );


    @ApiOperation(value = "获取物流列表", notes = "获取物流数据", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "数据列表")})
    @RequestMapping(value = "/logisticsPostcode",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getLogisticsPostcodeList(@ApiParam(value = "request", required = true) @Valid GetLogisticsPostcodeListRequest request
    );


    @ApiOperation(value = "新增物流", notes = "新增物流", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "新增结果")})
    @RequestMapping(value = "/logisticsPostcode",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse saveLogisticsPostcode(@ApiParam(value = "request", required = true) @Valid SaveLogisticsPostcodeRequest request
    );


    @ApiOperation(value = "更新物流信息", notes = "更新物流信息", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "更新结果")})
    @RequestMapping(value = "/logisticsPostcode",
        produces = {"application/json"},
        method = RequestMethod.PUT)
    CommonResponse updateLogisticsPostcode(@ApiParam(value = "request", required = true) @Valid UpdateLogisticsPostcodeRequest request
    );

}
