package com.xforceplus.elephant.image.client.api;

import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.ClearTicketDataRequest;
import com.xforceplus.elephant.image.client.model.DeleteTicketListRequest;
import com.xforceplus.elephant.image.client.model.GetBaseTicketListRequest;
import com.xforceplus.elephant.image.client.model.GetClaimTicketListRequest;
import com.xforceplus.elephant.image.client.model.GetExceAndWarnInfoRequest;
import com.xforceplus.elephant.image.client.model.GetHistoryLabelsRequest;
import com.xforceplus.elephant.image.client.model.GetTicketDataRequest;
import com.xforceplus.elephant.image.client.model.GetTicketDetailRequest;
import com.xforceplus.elephant.image.client.model.GetTicketManyRequest;
import com.xforceplus.elephant.image.client.model.GetTicketTypeListRequest;
import com.xforceplus.elephant.image.client.model.ReCheckTicketRequest;
import com.xforceplus.elephant.image.client.model.ReSendTicketRequest;
import com.xforceplus.elephant.image.client.model.SaveTicketDataRequest;
import com.xforceplus.elephant.image.client.model.SaveTicketDetailLabelsRequest;
import com.xforceplus.elephant.image.client.model.SaveTicketLabelsRequest;
import com.xforceplus.elephant.image.client.model.SelectTicketAttachmentRequest;
import com.xforceplus.elephant.image.client.model.SendVerifyRequest;
import com.xforceplus.elephant.image.client.model.SubmitCancelRequest;
import com.xforceplus.elephant.image.client.model.SubmitTicketRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


@Api(value = "ticket", description = "the ticket API", tags = "ticket")
public interface TicketApi {

    @ApiOperation(value = "清除单证结构数据", notes = "清除单证结构数据", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "数据列表")})
    @RequestMapping(value = "/ticket/clearTicketData",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse clearTicketData(@ApiParam(value = "request", required = true) @Valid ClearTicketDataRequest request
    );


    @ApiOperation(value = "批量删除个人单证池数据信息", notes = "批量删除个人单证池数据信息", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "删除结果")})
    @RequestMapping(value = "/ticket/deletePersonTicketList",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse deletePersonTicketList(@ApiParam(value = "request", required = true) @Valid DeleteTicketListRequest request
    );


    @ApiOperation(value = "批量删除公共单证池数据信息", notes = "批量删除公共单证池数据信息", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "删除结果")})
    @RequestMapping(value = "/ticket/deletePublicTicketList",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse deletePublicTicketList(@ApiParam(value = "request", required = true) @Valid DeleteTicketListRequest request
    );


    @ApiOperation(value = "获取认领单证数据", notes = "获取认领单证数据", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "数据列表")})
    @RequestMapping(value = "/ticket/getClaimTicketList",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getClaimTicketList(@ApiParam(value = "request", required = true) @Valid GetClaimTicketListRequest request
    );


    @ApiOperation(value = "获取异常预警信息", notes = "获取异常预警信息", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "数据列表")})
    @RequestMapping(value = "/ticket/getExceAndWarnInfo",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getExceAndWarnInfo(@ApiParam(value = "request", required = true) @Valid GetExceAndWarnInfoRequest request
    );


    @ApiOperation(value = "获取单证数据", notes = "获取单证数据", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "数据列表")})
    @RequestMapping(value = "/ticket/getTicketData",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getTicketData(@ApiParam(value = "request", required = true) @Valid GetTicketDataRequest request
    );


    @ApiOperation(value = "获取单证数据详情", notes = "获取单证数据详情", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "数据列表")})
    @RequestMapping(value = "/ticket/getTicketDetail",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getTicketDetail(@ApiParam(value = "request", required = true) @Valid GetTicketDetailRequest request
    );


    @ApiOperation(value = "多票查询", notes = "多票查询", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "数据列表")})
    @RequestMapping(value = "/ticket/ticketMany",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse getTicketMany(@ApiParam(value = "request", required = true) @Valid GetTicketManyRequest request
    );


    @ApiOperation(value = "获取单证类型集合", notes = "获取单证类型集合", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "数据列表")})
    @RequestMapping(value = "/ticket/getTicketTypeList",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getTicketTypeList(@ApiParam(value = "request", required = true) @Valid GetTicketTypeListRequest request
    );


    @ApiOperation(value = "重算单证", notes = "重算单证", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "响应结果")})
    @RequestMapping(value = "/ticket/reCheckTicket",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse reCheckTicket(@ApiParam(value = "request", required = true) @Valid ReCheckTicketRequest request
    );


    @ApiOperation(value = "重算单证", notes = "重算单证", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "响应结果")})
    @RequestMapping(value = "/ticket/reSendTicket",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse reSendTicket(@ApiParam(value = "request", required = true) @Valid ReSendTicketRequest request
    );


    @ApiOperation(value = "保存单证数据", notes = "保存单证数据", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "新增结果")})
    @RequestMapping(value = "/ticket/saveTicketData",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse saveTicketData(@ApiParam(value = "request", required = true) @Valid SaveTicketDataRequest request
    );

    @ApiOperation(value = "保存单证标签", notes = "保存单证标签", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "新增结果")})
    @RequestMapping(value = "/ticket/labels",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse saveTicketLabels(@ApiParam(value = "request", required = true) @Valid SaveTicketLabelsRequest request
    );

    @ApiOperation(value = "保存单证明细标签", notes = "保存单证明细标签", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "新增结果")})
    @RequestMapping(value = "/ticket/detail/labels",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse saveTicketDetailLabels(@ApiParam(value = "request", required = true) @Valid SaveTicketDetailLabelsRequest request
    );

    @ApiOperation(value = "查询单证标签使用历史", notes = "查询单证标签使用历史", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "新增结果")})
    @RequestMapping(value = "/ticket/labels/histories",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getHistoryLabels(@ApiParam(value = "request", required = true) @Valid GetHistoryLabelsRequest request
    );

    @ApiOperation(value = "获取单证下的清单和销货清单", notes = "获取单证下的清单和销货清单", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "数据列表")})
    @RequestMapping(value = "/ticket/selectTicketAttachment",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse selectTicketAttachment(@ApiParam(value = "request", required = true) @Valid SelectTicketAttachmentRequest request
    );


    @ApiOperation(value = "发送验真", notes = "发送验真", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "数据列表")})
    @RequestMapping(value = "/ticket/sendVerify",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse sendVerify(@ApiParam(value = "request", required = true) @Valid SendVerifyRequest request
    );


    @ApiOperation(value = "个人单证池发票提交", notes = "个人单证池发票提交", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "响应结果")})
    @RequestMapping(value = "/ticket/submitTicket",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse submitTicket(@ApiParam(value = "request", required = true) @Valid SubmitTicketRequest request
    );

    @ApiOperation(value = "获取发票类型集合", notes = "获取发票类型集合")
    @RequestMapping(value = "/ticket/getInvoiceTypeList", produces = {"application/json"}, method = RequestMethod.GET)
    CommonResponse getInvoiceTypeList(@ApiParam(value = "request", required = true) @Valid GetTicketTypeListRequest request);

    @ApiOperation(value = "获取基础单证列表", notes = "获取基础单证列表", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "响应结果")})
    @RequestMapping(value = "/ticket/getBaseTicketList",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getBaseTicketList(@ApiParam(value = "request", required = true) @Valid GetBaseTicketListRequest request);


    @ApiOperation(value = "获取占用信息", notes = "获取占用信息", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "响应结果")})
    @RequestMapping(value = "/ticket/getRepeatTicket/{ticketId}",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getRepeatTicket(@ApiParam(value = "自增主键", required = true) @PathVariable("ticketId") Long ticketId
        , @ApiParam(value = "request", required = true) @Valid BaseRequest request);

    @ApiOperation(value = "运维单证删除", notes = "运维单证删除", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "删除结果")})
    @RequestMapping(value = "/ticket/operationDeleteTicket",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse operationDeleteTicket(@ApiParam(value = "request", required = true) @Valid DeleteTicketListRequest request
    );

    @ApiOperation(value = "获取验真结果标识", notes = "获取验真结果标识", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "响应结果")})
    @RequestMapping(value = "/ticket/getVerifyTag/{ticketId}",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getVerifyTag(@ApiParam(value = "自增主键", required = true) @PathVariable("ticketId") Long ticketId);

    @ApiOperation(value = "发票撤销", notes = "发票撤销", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "响应结果")})
    @RequestMapping(value = "/ticket/submitCancel",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse submitCancel(@ApiParam(value = "request", required = true) @Valid SubmitCancelRequest request);

}
