package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/**
 * 校验岗单据影像请求
 */
@ApiModel(description = "校验岗单据影像请求")

@JsonInclude(NON_NULL)
public class CheckBillImageRequest extends BaseRequest {

    @JsonProperty("imageId")
    private Long imageId = null;

    @JsonProperty("hangStatus")
    private Integer hangStatus = null;

    @JsonProperty("backReason")
    private String backReason = null;

    @JsonIgnore
    public CheckBillImageRequest imageId(Long imageId) {
        this.imageId = imageId;
        return this;
    }

    /**
     * 影像id
     *
     * @return imageId
     **/
    @ApiModelProperty(value = "影像id")
    public Long getImageId() {
        return imageId;
    }

    public void setImageId(Long imageId) {
        this.imageId = imageId;
    }

    @JsonIgnore
    public CheckBillImageRequest hangStatus(Integer hangStatus) {
        this.hangStatus = hangStatus;
        return this;
    }

    /**
     * 挂起状态0-取消挂起，1-标记挂起
     *
     * @return hangStatus
     **/
    @ApiModelProperty(value = "挂起状态0-取消挂起，1-标记挂起")
    public Integer getHangStatus() {
        return hangStatus;
    }

    public void setHangStatus(Integer hangStatus) {
        this.hangStatus = hangStatus;
    }

    @JsonIgnore
    public CheckBillImageRequest backReason(String backReason) {
        this.backReason = backReason;
        return this;
    }

    /**
     * 退回原因
     *
     * @return backReason
     **/
    @ApiModelProperty(value = "退回原因")
    public String getBackReason() {
        return backReason;
    }

    public void setBackReason(String backReason) {
        this.backReason = backReason;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CheckBillImageRequest checkBillImageRequest = (CheckBillImageRequest) o;
        return Objects.equals(this.imageId, checkBillImageRequest.imageId) &&
            Objects.equals(this.hangStatus, checkBillImageRequest.hangStatus) &&
            Objects.equals(this.backReason, checkBillImageRequest.backReason) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(imageId, hangStatus, backReason, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CheckBillImageRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    imageId: ").append(toIndentedString(imageId)).append("\n");
        sb.append("    hangStatus: ").append(toIndentedString(hangStatus)).append("\n");
        sb.append("    backReason: ").append(toIndentedString(backReason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
