package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/**
 * 校验岗单据影像请求
 */
@ApiModel(description = "校验岗单据影像请求")

@JsonInclude(NON_NULL)
public class CheckSaveInvoiceCoverRequest extends BaseRequest {

    @JsonProperty("parTicketId")
    private Long parTicketId = null;

    @JsonProperty("subTicketId")
    private Long subTicketId = null;

    @JsonProperty("ticketCode")
    private String ticketCode = null;

    @JsonProperty("formData")
    private String formData = null;

    @JsonIgnore
    public CheckSaveInvoiceCoverRequest parTicketId(Long parTicketId) {
        this.parTicketId = parTicketId;
        return this;
    }

    /**
     * 父单证ID
     *
     * @return parTicketId
     **/
    @ApiModelProperty(value = "父单证ID")
    public Long getParTicketId() {
        return parTicketId;
    }

    public void setParTicketId(Long parTicketId) {
        this.parTicketId = parTicketId;
    }

    @JsonIgnore
    public CheckSaveInvoiceCoverRequest subTicketId(Long subTicketId) {
        this.subTicketId = subTicketId;
        return this;
    }

    /**
     * 子单证ID
     *
     * @return subTicketId
     **/
    @ApiModelProperty(value = "子单证ID")
    public Long getSubTicketId() {
        return subTicketId;
    }

    public void setSubTicketId(Long subTicketId) {
        this.subTicketId = subTicketId;
    }

    @JsonIgnore
    public CheckSaveInvoiceCoverRequest ticketCode(String ticketCode) {
        this.ticketCode = ticketCode;
        return this;
    }

    /**
     * 单证code
     *
     * @return ticketCode
     **/
    @ApiModelProperty(value = "单证code")
    public String getTicketCode() {
        return ticketCode;
    }

    public void setTicketCode(String ticketCode) {
        this.ticketCode = ticketCode;
    }

    @JsonIgnore
    public CheckSaveInvoiceCoverRequest formData(String formData) {
        this.formData = formData;
        return this;
    }

    /**
     * 表单数据
     *
     * @return formData
     **/
    @ApiModelProperty(value = "表单数据")
    public String getFormData() {
        return formData;
    }

    public void setFormData(String formData) {
        this.formData = formData;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CheckSaveInvoiceCoverRequest checkSaveInvoiceCoverRequest = (CheckSaveInvoiceCoverRequest) o;
        return Objects.equals(this.parTicketId, checkSaveInvoiceCoverRequest.parTicketId) &&
            Objects.equals(this.subTicketId, checkSaveInvoiceCoverRequest.subTicketId) &&
            Objects.equals(this.ticketCode, checkSaveInvoiceCoverRequest.ticketCode) &&
            Objects.equals(this.formData, checkSaveInvoiceCoverRequest.formData) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(parTicketId, subTicketId, ticketCode, formData, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CheckSaveInvoiceCoverRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    parTicketId: ").append(toIndentedString(parTicketId)).append("\n");
        sb.append("    subTicketId: ").append(toIndentedString(subTicketId)).append("\n");
        sb.append("    ticketCode: ").append(toIndentedString(ticketCode)).append("\n");
        sb.append("    formData: ").append(toIndentedString(formData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
