package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/**
 * 获取单据详情Request
 */
@ApiModel(description = "获取单据详情Request")

@JsonInclude(NON_NULL)
public class GetBaseBillDetailRequest extends BaseRequest {

    @JsonProperty("billCode")
    private String billCode = null;

    @JsonProperty("pageCode")
    private String pageCode = null;

    @JsonIgnore
    public GetBaseBillDetailRequest billCode(String billCode) {
        this.billCode = billCode;
        return this;
    }

    /**
     * 单据code
     *
     * @return billCode
     **/
    @ApiModelProperty(value = "单据code")
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @JsonIgnore
    public GetBaseBillDetailRequest pageCode(String pageCode) {
        this.pageCode = pageCode;
        return this;
    }

    /**
     * 页面Code
     *
     * @return pageCode
     **/
    @ApiModelProperty(value = "页面Code")
    public String getPageCode() {
        return pageCode;
    }

    public void setPageCode(String pageCode) {
        this.pageCode = pageCode;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetBaseBillDetailRequest getBaseBillDetailRequest = (GetBaseBillDetailRequest) o;
        return Objects.equals(this.billCode, getBaseBillDetailRequest.billCode) &&
            Objects.equals(this.pageCode, getBaseBillDetailRequest.pageCode) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(billCode, pageCode, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetBaseBillDetailRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    billCode: ").append(toIndentedString(billCode)).append("\n");
        sb.append("    pageCode: ").append(toIndentedString(pageCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
