package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/**
 * 获取单据类型集合Request
 */
@ApiModel(description = "获取单据类型集合Request")

@JsonInclude(NON_NULL)
public class GetBillTypeListRequest extends BaseRequest {

    @JsonProperty("pageCode")
    private String pageCode = null;

    @JsonIgnore
    public GetBillTypeListRequest pageCode(String pageCode) {
        this.pageCode = pageCode;
        return this;
    }

    /**
     * 页面code
     *
     * @return pageCode
     **/
    @ApiModelProperty(value = "页面code")
    public String getPageCode() {
        return pageCode;
    }

    public void setPageCode(String pageCode) {
        this.pageCode = pageCode;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetBillTypeListRequest getBillTypeListRequest = (GetBillTypeListRequest) o;
        return Objects.equals(this.pageCode, getBillTypeListRequest.pageCode) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(pageCode, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetBillTypeListRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    pageCode: ").append(toIndentedString(pageCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
