package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/**
 * 获取异常预警信息Request
 */
@ApiModel(description = "获取异常预警信息Request")

@JsonInclude(NON_NULL)
public class GetExceAndWarnInfoRequest extends BaseRequest {

    @JsonProperty("imageId")
    private Long imageId = null;

    @JsonProperty("imageType")
    private Integer imageType = null;

    @JsonIgnore
    public GetExceAndWarnInfoRequest imageId(Long imageId) {
        this.imageId = imageId;
        return this;
    }

    /**
     * 影像ID
     *
     * @return imageId
     **/
    @ApiModelProperty(value = "影像ID")
    public Long getImageId() {
        return imageId;
    }

    public void setImageId(Long imageId) {
        this.imageId = imageId;
    }

    @JsonIgnore
    public GetExceAndWarnInfoRequest imageType(Integer imageType) {
        this.imageType = imageType;
        return this;
    }

    /**
     * 影像类型：1-单据，2-单证
     *
     * @return imageType
     **/
    @ApiModelProperty(value = "影像类型：1-单据，2-单证")
    public Integer getImageType() {
        return imageType;
    }

    public void setImageType(Integer imageType) {
        this.imageType = imageType;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetExceAndWarnInfoRequest getExceAndWarnInfoRequest = (GetExceAndWarnInfoRequest) o;
        return Objects.equals(this.imageId, getExceAndWarnInfoRequest.imageId) &&
            Objects.equals(this.imageType, getExceAndWarnInfoRequest.imageType) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(imageId, imageType, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetExceAndWarnInfoRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    imageId: ").append(toIndentedString(imageId)).append("\n");
        sb.append("    imageType: ").append(toIndentedString(imageType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
