package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/**
 * 影像流
 */
@ApiModel(description = "影像流")

@JsonInclude(NON_NULL)
public class GetImageStreamRequest extends BaseRequest {

    @JsonProperty("isMore")
    private Integer isMore = null;

    @JsonIgnore
    public GetImageStreamRequest isMore(Integer isMore) {
        this.isMore = isMore;
        return this;
    }

    /**
     * 是否多票：0-否，1-是
     *
     * @return isMore
     **/
    @ApiModelProperty(value = "是否多票：0-否，1-是")
    public Integer getIsMore() {
        return isMore;
    }

    public void setIsMore(Integer isMore) {
        this.isMore = isMore;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetImageStreamRequest getImageStreamRequest = (GetImageStreamRequest) o;
        return Objects.equals(this.isMore, getImageStreamRequest.isMore) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(isMore, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetImageStreamRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    isMore: ").append(toIndentedString(isMore)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
