package com.xforceplus.elephant.image.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 获取单据列表资源码Request
 */
@ApiModel(description = "获取单据列表资源码Request")
public class GetListResourceCodeRequest extends BaseRequest {

    @JsonProperty("pageCode")
    private String pageCode = null;

    @JsonProperty("billDataStatus")
    private Integer billDataStatus;

    /**
     * 页面Code
     *
     * @return pageCode
     **/
    @ApiModelProperty(value = "页面Code")
    public String getPageCode() {
        return pageCode;
    }

    public void setPageCode(String pageCode) {
        this.pageCode = pageCode;
    }

    /**
     * 单据状态：0-待提交，1-已提交，2-暂挂起，3-已锁定，4-已退回，5-已作废
     *
     * @return billDataStatus
     **/
    @ApiModelProperty(value = "单据状态")
    public Integer getBillDataStatus() {
        return billDataStatus;
    }

    public void setBillDataStatus(Integer billDataStatus) {
        this.billDataStatus = billDataStatus;
    }

}
