package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.PageRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * Request
 */
@ApiModel(description = "Request")

@JsonInclude(NON_NULL)
public class GetLogApiListRequest extends PageRequest {

    @JsonProperty("number")
    private String number = null;

    @JsonProperty("methodCode")
    private String methodCode = null;

    @JsonProperty("systemType")
    private Integer systemType = null;

    @JsonProperty("sender")
    private String sender = null;

    @JsonProperty("receiver")
    private String receiver = null;

    @JsonProperty("methodUrl")
    private String methodUrl = null;

    @JsonProperty("methodName")
    private String methodName = null;

    @JsonProperty("isRetry")
    private Integer isRetry = null;

    @JsonProperty("isSuccess")
    private String isSuccess = null;

    @JsonProperty("isSuccessful")
    private Integer isSuccessful = null;

    @JsonProperty("createTime")
    private List<Long> createTime = new ArrayList<Long>();

    @JsonProperty("createUser")
    private String createUser = null;

    @JsonProperty("invoiceCode")
    private String invoiceCode = null;

    @JsonProperty("invoiceNo")
    private String invoiceNo = null;

    @JsonProperty("billCode")
    private String billCode = null;

    @JsonProperty("params")
    private String params = null;

    @JsonIgnore
    public GetLogApiListRequest number(String number) {
        this.number = number;
        return this;
    }

    /**
     * 流水号
     *
     * @return number
     **/
    @ApiModelProperty(value = "流水号")
    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    @JsonIgnore
    public GetLogApiListRequest methodCode(String methodCode) {
        this.methodCode = methodCode;
        return this;
    }

    /**
     * 方法code
     *
     * @return methodCode
     **/
    @ApiModelProperty(value = "方法code")
    public String getMethodCode() {
        return methodCode;
    }

    public void setMethodCode(String methodCode) {
        this.methodCode = methodCode;
    }

    @JsonIgnore
    public GetLogApiListRequest systemType(Integer systemType) {
        this.systemType = systemType;
        return this;
    }

    /**
     * 系统类型
     *
     * @return systemType
     **/
    @ApiModelProperty(value = "系统类型")
    public Integer getSystemType() {
        return systemType;
    }

    public void setSystemType(Integer systemType) {
        this.systemType = systemType;
    }

    @JsonIgnore
    public GetLogApiListRequest sender(String sender) {
        this.sender = sender;
        return this;
    }

    /**
     * null
     *
     * @return sender
     **/
    @ApiModelProperty(value = "null")
    public String getSender() {
        return sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    @JsonIgnore
    public GetLogApiListRequest receiver(String receiver) {
        this.receiver = receiver;
        return this;
    }

    /**
     * null
     *
     * @return receiver
     **/
    @ApiModelProperty(value = "null")
    public String getReceiver() {
        return receiver;
    }

    public void setReceiver(String receiver) {
        this.receiver = receiver;
    }

    @JsonIgnore
    public GetLogApiListRequest methodUrl(String methodUrl) {
        this.methodUrl = methodUrl;
        return this;
    }

    /**
     * null
     *
     * @return methodUrl
     **/
    @ApiModelProperty(value = "null")
    public String getMethodUrl() {
        return methodUrl;
    }

    public void setMethodUrl(String methodUrl) {
        this.methodUrl = methodUrl;
    }

    @JsonIgnore
    public GetLogApiListRequest methodName(String methodName) {
        this.methodName = methodName;
        return this;
    }

    /**
     * null
     *
     * @return methodName
     **/
    @ApiModelProperty(value = "null")
    public String getMethodName() {
        return methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    @JsonIgnore
    public GetLogApiListRequest isRetry(Integer isRetry) {
        this.isRetry = isRetry;
        return this;
    }

    /**
     * null
     *
     * @return isRetry
     **/
    @ApiModelProperty(value = "null")
    public Integer getIsRetry() {
        return isRetry;
    }

    public void setIsRetry(Integer isRetry) {
        this.isRetry = isRetry;
    }

    @JsonIgnore
    public GetLogApiListRequest isSuccess(String isSuccess) {
        this.isSuccess = isSuccess;
        return this;
    }

    /**
     * null
     *
     * @return isSuccess
     **/
    @ApiModelProperty(value = "null")
    public String getIsSuccess() {
        return isSuccess;
    }

    public void setIsSuccess(String isSuccess) {
        this.isSuccess = isSuccess;
    }

    @JsonIgnore
    public GetLogApiListRequest isSuccessful(Integer isSuccessful) {
        this.isSuccessful = isSuccessful;
        return this;
    }

    /**
     * null
     *
     * @return isSuccessful
     **/
    @ApiModelProperty(value = "null")
    public Integer getIsSuccessful() {
        return isSuccessful;
    }

    public void setIsSuccessful(Integer isSuccessful) {
        this.isSuccessful = isSuccessful;
    }

    @JsonIgnore
    public GetLogApiListRequest createTime(List<Long> createTime) {
        this.createTime = createTime;
        return this;
    }

    public GetLogApiListRequest addCreateTimeItem(Long createTimeItem) {
        this.createTime.add(createTimeItem);
        return this;
    }

    /**
     * 创建时间
     *
     * @return createTime
     **/
    @ApiModelProperty(value = "创建时间")
    public List<Long> getCreateTime() {
        return createTime;
    }

    public void setCreateTime(List<Long> createTime) {
        this.createTime = createTime;
    }

    @JsonIgnore
    public GetLogApiListRequest createUser(String createUser) {
        this.createUser = createUser;
        return this;
    }

    /**
     * null
     *
     * @return createUser
     **/
    @ApiModelProperty(value = "null")
    public String getCreateUser() {
        return createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    @JsonIgnore
    public GetLogApiListRequest invoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
        return this;
    }

    /**
     * null
     *
     * @return invoiceCode
     **/
    @ApiModelProperty(value = "null")
    public String getInvoiceCode() {
        return invoiceCode;
    }

    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }

    @JsonIgnore
    public GetLogApiListRequest invoiceNo(String invoiceNo) {
        this.invoiceNo = invoiceNo;
        return this;
    }

    /**
     * null
     *
     * @return invoiceNo
     **/
    @ApiModelProperty(value = "null")
    public String getInvoiceNo() {
        return invoiceNo;
    }

    public void setInvoiceNo(String invoiceNo) {
        this.invoiceNo = invoiceNo;
    }

    @JsonIgnore
    public GetLogApiListRequest billCode(String billCode) {
        this.billCode = billCode;
        return this;
    }

    /**
     * null
     *
     * @return billCode
     **/
    @ApiModelProperty(value = "null")
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @JsonIgnore
    public GetLogApiListRequest params(String params) {
        this.params = params;
        return this;
    }

    /**
     * 请求参数
     *
     * @return params
     **/
    @ApiModelProperty(value = "请求参数")
    public String getParams() {
        return params;
    }

    public void setParams(String params) {
        this.params = params;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetLogApiListRequest getLogApiListRequest = (GetLogApiListRequest) o;
        return Objects.equals(this.number, getLogApiListRequest.number) &&
            Objects.equals(this.methodCode, getLogApiListRequest.methodCode) &&
            Objects.equals(this.systemType, getLogApiListRequest.systemType) &&
            Objects.equals(this.sender, getLogApiListRequest.sender) &&
            Objects.equals(this.receiver, getLogApiListRequest.receiver) &&
            Objects.equals(this.methodUrl, getLogApiListRequest.methodUrl) &&
            Objects.equals(this.methodName, getLogApiListRequest.methodName) &&
            Objects.equals(this.isRetry, getLogApiListRequest.isRetry) &&
            Objects.equals(this.isSuccess, getLogApiListRequest.isSuccess) &&
            Objects.equals(this.isSuccessful, getLogApiListRequest.isSuccessful) &&
            Objects.equals(this.createTime, getLogApiListRequest.createTime) &&
            Objects.equals(this.createUser, getLogApiListRequest.createUser) &&
            Objects.equals(this.invoiceCode, getLogApiListRequest.invoiceCode) &&
            Objects.equals(this.invoiceNo, getLogApiListRequest.invoiceNo) &&
            Objects.equals(this.billCode, getLogApiListRequest.billCode) &&
            Objects.equals(this.params, getLogApiListRequest.params) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(number, methodCode, systemType, sender, receiver, methodUrl, methodName, isRetry, isSuccess, isSuccessful, createTime, createUser, invoiceCode, invoiceNo, billCode, params,
            super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetLogApiListRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    number: ").append(toIndentedString(number)).append("\n");
        sb.append("    methodCode: ").append(toIndentedString(methodCode)).append("\n");
        sb.append("    systemType: ").append(toIndentedString(systemType)).append("\n");
        sb.append("    sender: ").append(toIndentedString(sender)).append("\n");
        sb.append("    receiver: ").append(toIndentedString(receiver)).append("\n");
        sb.append("    methodUrl: ").append(toIndentedString(methodUrl)).append("\n");
        sb.append("    methodName: ").append(toIndentedString(methodName)).append("\n");
        sb.append("    isRetry: ").append(toIndentedString(isRetry)).append("\n");
        sb.append("    isSuccess: ").append(toIndentedString(isSuccess)).append("\n");
        sb.append("    isSuccessful: ").append(toIndentedString(isSuccessful)).append("\n");
        sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
        sb.append("    createUser: ").append(toIndentedString(createUser)).append("\n");
        sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
        sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
        sb.append("    billCode: ").append(toIndentedString(billCode)).append("\n");
        sb.append("    params: ").append(toIndentedString(params)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
