package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.PageRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 删除个人单证池发票影像Request
 */
@ApiModel(description = "删除个人单证池发票影像Request")

@JsonInclude(NON_NULL)
public class GetPersonTicketDataListRequest extends PageRequest {

    @JsonProperty("ticketCreateTime")
    private List<Long> ticketCreateTime = new ArrayList<Long>();

    @JsonProperty("ticketDataType")
    private String ticketDataType = null;

    @JsonProperty("warningStatus")
    private Integer warningStatus = null;

    @JsonProperty("exceptionStatus")
    private Integer exceptionStatus = null;

    @JsonProperty("checkStatus")
    private List<Integer> checkStatus = new ArrayList<Integer>();

    @JsonProperty("isHooked")
    private Integer isHooked = null;

    @JsonProperty("invoiceNo")
    private String invoiceNo = null;

    @JsonProperty("invoiceCode")
    private String invoiceCode = null;

    @JsonProperty("attachmentName")
    private String attachmentName = null;

    @JsonProperty("labelName")
    private String labelName = null;

    @JsonIgnore
    public GetPersonTicketDataListRequest ticketCreateTime(List<Long> ticketCreateTime) {
        this.ticketCreateTime = ticketCreateTime;
        return this;
    }

    public GetPersonTicketDataListRequest addTicketCreateTimeItem(Long ticketCreateTimeItem) {
        this.ticketCreateTime.add(ticketCreateTimeItem);
        return this;
    }

    /**
     * 上传时间
     *
     * @return ticketCreateTime
     **/
    @ApiModelProperty(value = "上传时间")
    public List<Long> getTicketCreateTime() {
        return ticketCreateTime;
    }

    public void setTicketCreateTime(List<Long> ticketCreateTime) {
        this.ticketCreateTime = ticketCreateTime;
    }

    @JsonIgnore
    public GetPersonTicketDataListRequest ticketDataType(String ticketDataType) {
        this.ticketDataType = ticketDataType;
        return this;
    }

    /**
     * 单证类型：s-增值税专用发票,d-多票，f-附件
     *
     * @return ticketDataType
     **/
    @ApiModelProperty(value = "单证类型：s-增值税专用发票,d-多票，f-附件")
    public String getTicketDataType() {
        return ticketDataType;
    }

    public void setTicketDataType(String ticketDataType) {
        this.ticketDataType = ticketDataType;
    }

    @JsonIgnore
    public GetPersonTicketDataListRequest warningStatus(Integer warningStatus) {
        this.warningStatus = warningStatus;
        return this;
    }

    /**
     * 预警状态：0-否，1-是
     *
     * @return warningStatus
     **/
    @ApiModelProperty(value = "预警状态：0-否，1-是")
    public Integer getWarningStatus() {
        return warningStatus;
    }

    public void setWarningStatus(Integer warningStatus) {
        this.warningStatus = warningStatus;
    }

    @JsonIgnore
    public GetPersonTicketDataListRequest exceptionStatus(Integer exceptionStatus) {
        this.exceptionStatus = exceptionStatus;
        return this;
    }

    /**
     * 异常状态：0-否，1-是
     *
     * @return exceptionStatus
     **/
    @ApiModelProperty(value = "异常状态：0-否，1-是")
    public Integer getExceptionStatus() {
        return exceptionStatus;
    }

    public void setExceptionStatus(Integer exceptionStatus) {
        this.exceptionStatus = exceptionStatus;
    }

    @JsonIgnore
    public GetPersonTicketDataListRequest checkStatus(List<Integer> checkStatus) {
        this.checkStatus = checkStatus;
        return this;
    }

    public GetPersonTicketDataListRequest addCheckStatusItem(Integer checkStatusItem) {
        this.checkStatus.add(checkStatusItem);
        return this;
    }

    /**
     * 验真状态：0-待验真，1-验真中，2-验真成功，3-验真失败
     *
     * @return checkStatus
     **/
    @ApiModelProperty(value = "验真状态：0-待验真，1-验真中，2-验真成功，3-验真失败")
    public List<Integer> getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(List<Integer> checkStatus) {
        this.checkStatus = checkStatus;
    }

    @JsonIgnore
    public GetPersonTicketDataListRequest isHooked(Integer isHooked) {
        this.isHooked = isHooked;
        return this;
    }

    /**
     * 是否已挂接：0-否，1-是
     *
     * @return isHooked
     **/
    @ApiModelProperty(value = "是否已挂接：0-否，1-是")
    public Integer getIsHooked() {
        return isHooked;
    }

    public void setIsHooked(Integer isHooked) {
        this.isHooked = isHooked;
    }

    @JsonIgnore
    public GetPersonTicketDataListRequest invoiceNo(String invoiceNo) {
        this.invoiceNo = invoiceNo;
        return this;
    }

    /**
     * 发票号码
     *
     * @return invoiceNo
     **/
    @ApiModelProperty(value = "发票号码")
    public String getInvoiceNo() {
        return invoiceNo;
    }

    public void setInvoiceNo(String invoiceNo) {
        this.invoiceNo = invoiceNo;
    }

    @JsonIgnore
    public GetPersonTicketDataListRequest invoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
        return this;
    }

    /**
     * 发票代码
     *
     * @return invoiceCode
     **/
    @ApiModelProperty(value = "发票代码")
    public String getInvoiceCode() {
        return invoiceCode;
    }

    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }

    @JsonIgnore
    public GetPersonTicketDataListRequest attachmentName(String attachmentName) {
        this.attachmentName = attachmentName;
        return this;
    }

    /**
     * 附件名称
     *
     * @return attachmentName
     **/
    @ApiModelProperty(value = "附件名称")
    public String getAttachmentName() {
        return attachmentName;
    }

    public void setAttachmentName(String attachmentName) {
        this.attachmentName = attachmentName;
    }

    @JsonIgnore
    public GetPersonTicketDataListRequest labelName(String labelName) {
        this.labelName = labelName;
        return this;
    }

    /**
     * 标签名
     *
     * @return labelName
     **/
    @ApiModelProperty(value = "标签名")
    public String getLabelName() {
        return labelName;
    }

    public void setLabelName(String labelName) {
        this.labelName = labelName;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetPersonTicketDataListRequest getPersonTicketDataListRequest = (GetPersonTicketDataListRequest) o;
        return Objects.equals(this.ticketCreateTime, getPersonTicketDataListRequest.ticketCreateTime) &&
            Objects.equals(this.ticketDataType, getPersonTicketDataListRequest.ticketDataType) &&
            Objects.equals(this.warningStatus, getPersonTicketDataListRequest.warningStatus) &&
            Objects.equals(this.exceptionStatus, getPersonTicketDataListRequest.exceptionStatus) &&
            Objects.equals(this.checkStatus, getPersonTicketDataListRequest.checkStatus) &&
            Objects.equals(this.isHooked, getPersonTicketDataListRequest.isHooked) &&
            Objects.equals(this.invoiceNo, getPersonTicketDataListRequest.invoiceNo) &&
            Objects.equals(this.invoiceCode, getPersonTicketDataListRequest.invoiceCode) &&
            Objects.equals(this.attachmentName, getPersonTicketDataListRequest.attachmentName) &&
            Objects.equals(this.labelName, getPersonTicketDataListRequest.labelName) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(ticketCreateTime, ticketDataType, warningStatus, exceptionStatus, checkStatus, isHooked, invoiceNo, invoiceCode, attachmentName, labelName, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetPersonTicketDataListRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    ticketCreateTime: ").append(toIndentedString(ticketCreateTime)).append("\n");
        sb.append("    ticketDataType: ").append(toIndentedString(ticketDataType)).append("\n");
        sb.append("    warningStatus: ").append(toIndentedString(warningStatus)).append("\n");
        sb.append("    exceptionStatus: ").append(toIndentedString(exceptionStatus)).append("\n");
        sb.append("    checkStatus: ").append(toIndentedString(checkStatus)).append("\n");
        sb.append("    isHooked: ").append(toIndentedString(isHooked)).append("\n");
        sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
        sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
        sb.append("    attachmentName: ").append(toIndentedString(attachmentName)).append("\n");
        sb.append("    labelName: ").append(toIndentedString(labelName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
