package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.PageRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * Request
 */
@ApiModel(description = "Request")

@JsonInclude(NON_NULL)
public class GetPubSubLogListRequest extends PageRequest {

    @JsonProperty("number")
    private String number = null;

    @JsonProperty("type")
    private Integer type = null;

    @JsonProperty("requestName")
    private String requestName = null;

    @JsonProperty("sender")
    private String sender = null;

    @JsonProperty("reciver")
    private String reciver = null;

    @JsonProperty("createTime")
    private List<Long> createTime = new ArrayList<Long>();

    @JsonProperty("params")
    private String params = null;

    @JsonProperty("isSuccessful")
    private Integer isSuccessful = null;

    @JsonIgnore
    public GetPubSubLogListRequest number(String number) {
        this.number = number;
        return this;
    }

    /**
     * 流水号
     *
     * @return number
     **/
    @ApiModelProperty(value = "流水号")
    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    @JsonIgnore
    public GetPubSubLogListRequest type(Integer type) {
        this.type = type;
        return this;
    }

    /**
     * 0 默认 1发送 2 接收
     *
     * @return type
     **/
    @ApiModelProperty(value = "0 默认 1发送 2 接收")
    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    @JsonIgnore
    public GetPubSubLogListRequest requestName(String requestName) {
        this.requestName = requestName;
        return this;
    }

    /**
     * 队列名
     *
     * @return requestName
     **/
    @ApiModelProperty(value = "队列名")
    public String getRequestName() {
        return requestName;
    }

    public void setRequestName(String requestName) {
        this.requestName = requestName;
    }

    @JsonIgnore
    public GetPubSubLogListRequest sender(String sender) {
        this.sender = sender;
        return this;
    }

    /**
     * null
     *
     * @return sender
     **/
    @ApiModelProperty(value = "null")
    public String getSender() {
        return sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    @JsonIgnore
    public GetPubSubLogListRequest reciver(String reciver) {
        this.reciver = reciver;
        return this;
    }

    /**
     * null
     *
     * @return reciver
     **/
    @ApiModelProperty(value = "null")
    public String getReciver() {
        return reciver;
    }

    public void setReciver(String reciver) {
        this.reciver = reciver;
    }

    @JsonIgnore
    public GetPubSubLogListRequest createTime(List<Long> createTime) {
        this.createTime = createTime;
        return this;
    }

    public GetPubSubLogListRequest addCreateTimeItem(Long createTimeItem) {
        this.createTime.add(createTimeItem);
        return this;
    }

    /**
     * 创建时间
     *
     * @return createTime
     **/
    @ApiModelProperty(value = "创建时间")
    public List<Long> getCreateTime() {
        return createTime;
    }

    public void setCreateTime(List<Long> createTime) {
        this.createTime = createTime;
    }

    @JsonIgnore
    public GetPubSubLogListRequest params(String params) {
        this.params = params;
        return this;
    }

    /**
     * 请求参数
     *
     * @return params
     **/
    @ApiModelProperty(value = "请求参数")
    public String getParams() {
        return params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    @JsonIgnore
    public GetPubSubLogListRequest isSuccessful(Integer isSuccessful) {
        this.isSuccessful = isSuccessful;
        return this;
    }

    /**
     * 是否成功 0失败 1成功
     *
     * @return isSuccessful
     **/
    @ApiModelProperty(value = "是否成功 0失败 1成功")
    public Integer getIsSuccessful() {
        return isSuccessful;
    }

    public void setIsSuccessful(Integer isSuccessful) {
        this.isSuccessful = isSuccessful;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetPubSubLogListRequest getPubSubLogListRequest = (GetPubSubLogListRequest) o;
        return Objects.equals(this.number, getPubSubLogListRequest.number) &&
            Objects.equals(this.type, getPubSubLogListRequest.type) &&
            Objects.equals(this.requestName, getPubSubLogListRequest.requestName) &&
            Objects.equals(this.sender, getPubSubLogListRequest.sender) &&
            Objects.equals(this.reciver, getPubSubLogListRequest.reciver) &&
            Objects.equals(this.createTime, getPubSubLogListRequest.createTime) &&
            Objects.equals(this.params, getPubSubLogListRequest.params) &&
            Objects.equals(this.isSuccessful, getPubSubLogListRequest.isSuccessful) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(number, type, requestName, sender, reciver, createTime, params, isSuccessful, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetPubSubLogListRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    number: ").append(toIndentedString(number)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("    requestName: ").append(toIndentedString(requestName)).append("\n");
        sb.append("    sender: ").append(toIndentedString(sender)).append("\n");
        sb.append("    reciver: ").append(toIndentedString(reciver)).append("\n");
        sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
        sb.append("    params: ").append(toIndentedString(params)).append("\n");
        sb.append("    isSuccessful: ").append(toIndentedString(isSuccessful)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
