package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.PageRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/**
 * 票证数据Request
 */
@ApiModel(description = "票证数据Request")

@JsonInclude(NON_NULL)
public class GetTicketDataListRequest extends PageRequest {

    @JsonProperty("ticketDataId")
    private Long ticketDataId = null;

    @JsonProperty("ticketDataType")
    private String ticketDataType = null;

    @JsonProperty("tenantId")
    private Long tenantId = null;

    @JsonProperty("imageId")
    private Long imageId = null;

    @JsonProperty("billCode")
    private String billCode = null;

    @JsonProperty("batchNo")
    private String batchNo = null;

    @JsonProperty("warningStatus")
    private Integer warningStatus = null;

    @JsonProperty("warningInfo")
    private String warningInfo = null;

    @JsonProperty("exceptionStatus")
    private Integer exceptionStatus = null;

    @JsonProperty("exceptionInfo")
    private String exceptionInfo = null;

    @JsonProperty("checkStatus")
    private Integer checkStatus = null;

    @JsonProperty("checkRemark")
    private String checkRemark = null;

    @JsonProperty("checkTaskId")
    private String checkTaskId = null;

    @JsonProperty("checkRequestTime")
    private Long checkRequestTime = null;

    @JsonProperty("checkResponseTime")
    private Long checkResponseTime = null;

    @JsonProperty("checkUserId")
    private Long checkUserId = null;

    @JsonProperty("checkUserName")
    private String checkUserName = null;

    @JsonProperty("isHooked")
    private Integer isHooked = null;

    @JsonProperty("createTime")
    private Long createTime = null;

    @JsonProperty("createUserId")
    private Long createUserId = null;

    @JsonProperty("createUserName")
    private String createUserName = null;

    @JsonProperty("updateTime")
    private Long updateTime = null;

    @JsonProperty("updateUserId")
    private Long updateUserId = null;

    @JsonProperty("updateUserName")
    private String updateUserName = null;

    @JsonProperty("ticketCreateTime")
    private Long ticketCreateTime = null;

    @JsonIgnore
    public GetTicketDataListRequest ticketDataId(Long ticketDataId) {
        this.ticketDataId = ticketDataId;
        return this;
    }

    /**
     * 自增主键
     *
     * @return ticketDataId
     **/
    @ApiModelProperty(value = "自增主键")
    public Long getTicketDataId() {
        return ticketDataId;
    }

    public void setTicketDataId(Long ticketDataId) {
        this.ticketDataId = ticketDataId;
    }

    @JsonIgnore
    public GetTicketDataListRequest ticketDataType(String ticketDataType) {
        this.ticketDataType = ticketDataType;
        return this;
    }

    /**
     * 单证类型：s-增值税专用发票,d-多票，f-附件
     *
     * @return ticketDataType
     **/
    @ApiModelProperty(value = "单证类型：s-增值税专用发票,d-多票，f-附件")
    public String getTicketDataType() {
        return ticketDataType;
    }

    public void setTicketDataType(String ticketDataType) {
        this.ticketDataType = ticketDataType;
    }

    @JsonIgnore
    public GetTicketDataListRequest tenantId(Long tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    /**
     * 租户ID
     *
     * @return tenantId
     **/
    @ApiModelProperty(value = "租户ID")
    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    @JsonIgnore
    public GetTicketDataListRequest imageId(Long imageId) {
        this.imageId = imageId;
        return this;
    }

    /**
     * 影像ID
     *
     * @return imageId
     **/
    @ApiModelProperty(value = "影像ID")
    public Long getImageId() {
        return imageId;
    }

    public void setImageId(Long imageId) {
        this.imageId = imageId;
    }

    @JsonIgnore
    public GetTicketDataListRequest billCode(String billCode) {
        this.billCode = billCode;
        return this;
    }

    /**
     * 业务单号
     *
     * @return billCode
     **/
    @ApiModelProperty(value = "业务单号")
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @JsonIgnore
    public GetTicketDataListRequest batchNo(String batchNo) {
        this.batchNo = batchNo;
        return this;
    }

    /**
     * 扫描批次号
     *
     * @return batchNo
     **/
    @ApiModelProperty(value = "扫描批次号")
    public String getBatchNo() {
        return batchNo;
    }

    public void setBatchNo(String batchNo) {
        this.batchNo = batchNo;
    }

    @JsonIgnore
    public GetTicketDataListRequest warningStatus(Integer warningStatus) {
        this.warningStatus = warningStatus;
        return this;
    }

    /**
     * 预警状态：0-否，1-是
     *
     * @return warningStatus
     **/
    @ApiModelProperty(value = "预警状态：0-否，1-是")
    public Integer getWarningStatus() {
        return warningStatus;
    }

    public void setWarningStatus(Integer warningStatus) {
        this.warningStatus = warningStatus;
    }

    @JsonIgnore
    public GetTicketDataListRequest warningInfo(String warningInfo) {
        this.warningInfo = warningInfo;
        return this;
    }

    /**
     * 预警信息
     *
     * @return warningInfo
     **/
    @ApiModelProperty(value = "预警信息")
    public String getWarningInfo() {
        return warningInfo;
    }

    public void setWarningInfo(String warningInfo) {
        this.warningInfo = warningInfo;
    }

    @JsonIgnore
    public GetTicketDataListRequest exceptionStatus(Integer exceptionStatus) {
        this.exceptionStatus = exceptionStatus;
        return this;
    }

    /**
     * 异常状态：0-否，1-是
     *
     * @return exceptionStatus
     **/
    @ApiModelProperty(value = "异常状态：0-否，1-是")
    public Integer getExceptionStatus() {
        return exceptionStatus;
    }

    public void setExceptionStatus(Integer exceptionStatus) {
        this.exceptionStatus = exceptionStatus;
    }

    @JsonIgnore
    public GetTicketDataListRequest exceptionInfo(String exceptionInfo) {
        this.exceptionInfo = exceptionInfo;
        return this;
    }

    /**
     * 异常信息
     *
     * @return exceptionInfo
     **/
    @ApiModelProperty(value = "异常信息")
    public String getExceptionInfo() {
        return exceptionInfo;
    }

    public void setExceptionInfo(String exceptionInfo) {
        this.exceptionInfo = exceptionInfo;
    }

    @JsonIgnore
    public GetTicketDataListRequest checkStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
        return this;
    }

    /**
     * 验真状态：0-待验真，1-验真中，2-验真成功，3-验真失败
     *
     * @return checkStatus
     **/
    @ApiModelProperty(value = "验真状态：0-待验真，1-验真中，2-验真成功，3-验真失败")
    public Integer getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    @JsonIgnore
    public GetTicketDataListRequest checkRemark(String checkRemark) {
        this.checkRemark = checkRemark;
        return this;
    }

    /**
     * 验真备注
     *
     * @return checkRemark
     **/
    @ApiModelProperty(value = "验真备注")
    public String getCheckRemark() {
        return checkRemark;
    }

    public void setCheckRemark(String checkRemark) {
        this.checkRemark = checkRemark;
    }

    @JsonIgnore
    public GetTicketDataListRequest checkTaskId(String checkTaskId) {
        this.checkTaskId = checkTaskId;
        return this;
    }

    /**
     * 验真任务ID
     *
     * @return checkTaskId
     **/
    @ApiModelProperty(value = "验真任务ID")
    public String getCheckTaskId() {
        return checkTaskId;
    }

    public void setCheckTaskId(String checkTaskId) {
        this.checkTaskId = checkTaskId;
    }

    @JsonIgnore
    public GetTicketDataListRequest checkRequestTime(Long checkRequestTime) {
        this.checkRequestTime = checkRequestTime;
        return this;
    }

    /**
     * 验真请求时间
     *
     * @return checkRequestTime
     **/
    @ApiModelProperty(value = "验真请求时间")
    public Long getCheckRequestTime() {
        return checkRequestTime;
    }

    public void setCheckRequestTime(Long checkRequestTime) {
        this.checkRequestTime = checkRequestTime;
    }

    @JsonIgnore
    public GetTicketDataListRequest checkResponseTime(Long checkResponseTime) {
        this.checkResponseTime = checkResponseTime;
        return this;
    }

    /**
     * 验真返回时间
     *
     * @return checkResponseTime
     **/
    @ApiModelProperty(value = "验真返回时间")
    public Long getCheckResponseTime() {
        return checkResponseTime;
    }

    public void setCheckResponseTime(Long checkResponseTime) {
        this.checkResponseTime = checkResponseTime;
    }

    @JsonIgnore
    public GetTicketDataListRequest checkUserId(Long checkUserId) {
        this.checkUserId = checkUserId;
        return this;
    }

    /**
     * 验真人ID
     *
     * @return checkUserId
     **/
    @ApiModelProperty(value = "验真人ID")
    public Long getCheckUserId() {
        return checkUserId;
    }

    public void setCheckUserId(Long checkUserId) {
        this.checkUserId = checkUserId;
    }

    @JsonIgnore
    public GetTicketDataListRequest checkUserName(String checkUserName) {
        this.checkUserName = checkUserName;
        return this;
    }

    /**
     * 验真人姓名
     *
     * @return checkUserName
     **/
    @ApiModelProperty(value = "验真人姓名")
    public String getCheckUserName() {
        return checkUserName;
    }

    public void setCheckUserName(String checkUserName) {
        this.checkUserName = checkUserName;
    }

    @JsonIgnore
    public GetTicketDataListRequest isHooked(Integer isHooked) {
        this.isHooked = isHooked;
        return this;
    }

    /**
     * 是否已挂接：0-否，1-是
     *
     * @return isHooked
     **/
    @ApiModelProperty(value = "是否已挂接：0-否，1-是")
    public Integer getIsHooked() {
        return isHooked;
    }

    public void setIsHooked(Integer isHooked) {
        this.isHooked = isHooked;
    }

    @JsonIgnore
    public GetTicketDataListRequest createTime(Long createTime) {
        this.createTime = createTime;
        return this;
    }

    /**
     * 创建时间
     *
     * @return createTime
     **/
    @ApiModelProperty(value = "创建时间")
    public Long getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    @JsonIgnore
    public GetTicketDataListRequest createUserId(Long createUserId) {
        this.createUserId = createUserId;
        return this;
    }

    /**
     * 创建人ID
     *
     * @return createUserId
     **/
    @ApiModelProperty(value = "创建人ID")
    public Long getCreateUser() {
        return createUserId;
    }

    public void setCreateUser(Long createUserId) {
        this.createUserId = createUserId;
    }

    @JsonIgnore
    public GetTicketDataListRequest createUserName(String createUserName) {
        this.createUserName = createUserName;
        return this;
    }

    /**
     * 创建人姓名
     *
     * @return createUserName
     **/
    @ApiModelProperty(value = "创建人姓名")
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    @JsonIgnore
    public GetTicketDataListRequest updateTime(Long updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    /**
     * 更新时间
     *
     * @return updateTime
     **/
    @ApiModelProperty(value = "更新时间")
    public Long getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
    }

    @JsonIgnore
    public GetTicketDataListRequest updateUserId(Long updateUserId) {
        this.updateUserId = updateUserId;
        return this;
    }

    /**
     * 更新人ID
     *
     * @return updateUserId
     **/
    @ApiModelProperty(value = "更新人ID")
    public Long getUpdateUserId() {
        return updateUserId;
    }

    public void setUpdateUserId(Long updateUserId) {
        this.updateUserId = updateUserId;
    }

    @JsonIgnore
    public GetTicketDataListRequest updateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
        return this;
    }

    /**
     * 更新人姓名
     *
     * @return updateUserName
     **/
    @ApiModelProperty(value = "更新人姓名")
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    @JsonIgnore
    public GetTicketDataListRequest ticketCreateTime(Long ticketCreateTime) {
        this.ticketCreateTime = ticketCreateTime;
        return this;
    }

    /**
     * 上传时间
     *
     * @return ticketCreateTime
     **/
    @ApiModelProperty(value = "上传时间")
    public Long getTicketCreateTime() {
        return ticketCreateTime;
    }

    public void setTicketCreateTime(Long ticketCreateTime) {
        this.ticketCreateTime = ticketCreateTime;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetTicketDataListRequest getTicketDataListRequest = (GetTicketDataListRequest) o;
        return Objects.equals(this.ticketDataId, getTicketDataListRequest.ticketDataId) &&
            Objects.equals(this.ticketDataType, getTicketDataListRequest.ticketDataType) &&
            Objects.equals(this.tenantId, getTicketDataListRequest.tenantId) &&
            Objects.equals(this.imageId, getTicketDataListRequest.imageId) &&
            Objects.equals(this.billCode, getTicketDataListRequest.billCode) &&
            Objects.equals(this.batchNo, getTicketDataListRequest.batchNo) &&
            Objects.equals(this.warningStatus, getTicketDataListRequest.warningStatus) &&
            Objects.equals(this.warningInfo, getTicketDataListRequest.warningInfo) &&
            Objects.equals(this.exceptionStatus, getTicketDataListRequest.exceptionStatus) &&
            Objects.equals(this.exceptionInfo, getTicketDataListRequest.exceptionInfo) &&
            Objects.equals(this.checkStatus, getTicketDataListRequest.checkStatus) &&
            Objects.equals(this.checkRemark, getTicketDataListRequest.checkRemark) &&
            Objects.equals(this.checkTaskId, getTicketDataListRequest.checkTaskId) &&
            Objects.equals(this.checkRequestTime, getTicketDataListRequest.checkRequestTime) &&
            Objects.equals(this.checkResponseTime, getTicketDataListRequest.checkResponseTime) &&
            Objects.equals(this.checkUserId, getTicketDataListRequest.checkUserId) &&
            Objects.equals(this.checkUserName, getTicketDataListRequest.checkUserName) &&
            Objects.equals(this.isHooked, getTicketDataListRequest.isHooked) &&
            Objects.equals(this.createTime, getTicketDataListRequest.createTime) &&
            Objects.equals(this.createUserId, getTicketDataListRequest.createUserId) &&
            Objects.equals(this.createUserName, getTicketDataListRequest.createUserName) &&
            Objects.equals(this.updateTime, getTicketDataListRequest.updateTime) &&
            Objects.equals(this.updateUserId, getTicketDataListRequest.updateUserId) &&
            Objects.equals(this.updateUserName, getTicketDataListRequest.updateUserName) &&
            Objects.equals(this.ticketCreateTime, getTicketDataListRequest.ticketCreateTime) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(ticketDataId, ticketDataType, tenantId, imageId, billCode, batchNo, warningStatus, warningInfo, exceptionStatus, exceptionInfo, checkStatus, checkRemark, checkTaskId,
            checkRequestTime, checkResponseTime, checkUserId, checkUserName, isHooked, createTime, createUserId, createUserName, updateTime, updateUserId, updateUserName, ticketCreateTime,
            super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetTicketDataListRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    ticketDataId: ").append(toIndentedString(ticketDataId)).append("\n");
        sb.append("    ticketDataType: ").append(toIndentedString(ticketDataType)).append("\n");
        sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
        sb.append("    imageId: ").append(toIndentedString(imageId)).append("\n");
        sb.append("    billCode: ").append(toIndentedString(billCode)).append("\n");
        sb.append("    batchNo: ").append(toIndentedString(batchNo)).append("\n");
        sb.append("    warningStatus: ").append(toIndentedString(warningStatus)).append("\n");
        sb.append("    warningInfo: ").append(toIndentedString(warningInfo)).append("\n");
        sb.append("    exceptionStatus: ").append(toIndentedString(exceptionStatus)).append("\n");
        sb.append("    exceptionInfo: ").append(toIndentedString(exceptionInfo)).append("\n");
        sb.append("    checkStatus: ").append(toIndentedString(checkStatus)).append("\n");
        sb.append("    checkRemark: ").append(toIndentedString(checkRemark)).append("\n");
        sb.append("    checkTaskId: ").append(toIndentedString(checkTaskId)).append("\n");
        sb.append("    checkRequestTime: ").append(toIndentedString(checkRequestTime)).append("\n");
        sb.append("    checkResponseTime: ").append(toIndentedString(checkResponseTime)).append("\n");
        sb.append("    checkUserId: ").append(toIndentedString(checkUserId)).append("\n");
        sb.append("    checkUserName: ").append(toIndentedString(checkUserName)).append("\n");
        sb.append("    isHooked: ").append(toIndentedString(isHooked)).append("\n");
        sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
        sb.append("    createUserId: ").append(toIndentedString(createUserId)).append("\n");
        sb.append("    createUserName: ").append(toIndentedString(createUserName)).append("\n");
        sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
        sb.append("    updateUserId: ").append(toIndentedString(updateUserId)).append("\n");
        sb.append("    updateUserName: ").append(toIndentedString(updateUserName)).append("\n");
        sb.append("    ticketCreateTime: ").append(toIndentedString(ticketCreateTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
