package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.PageRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 多票查询Request
 */
@ApiModel(description = "多票查询Request")

@JsonInclude(NON_NULL)
public class GetTicketManyRequest extends PageRequest {

    @JsonProperty("imageIds")
    private List<Long> imageIds = new ArrayList<Long>();

    @JsonIgnore
    public GetTicketManyRequest imageIds(List<Long> imageIds) {
        this.imageIds = imageIds;
        return this;
    }

    public GetTicketManyRequest addImageIdsItem(Long imageIdsItem) {
        this.imageIds.add(imageIdsItem);
        return this;
    }

    /**
     * 单证的影像ids
     *
     * @return imageIds
     **/
    @ApiModelProperty(value = "单证的影像ids")
    public List<Long> getImageIds() {
        return imageIds;
    }

    public void setImageIds(List<Long> imageIds) {
        this.imageIds = imageIds;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetTicketManyRequest getTicketManyRequest = (GetTicketManyRequest) o;
        return Objects.equals(this.imageIds, getTicketManyRequest.imageIds) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(imageIds, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetTicketManyRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    imageIds: ").append(toIndentedString(imageIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
