package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.annotation.Description;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;

/**
 * 影像表
 */
@ApiModel(description = "影像表")

@JsonInclude(NON_NULL)
public class ImageDTO {

    @JsonProperty("id")
    private Long id = null;

    @JsonProperty("tenantId")
    private Long tenantId = null;

    @JsonProperty("billCode")
    private String billCode = null;

    @JsonProperty("batchNo")
    private String batchNo = null;

    @JsonProperty("imageCategory")
    private Integer imageCategory = null;

    @JsonProperty("imageType")
    private Integer imageType = null;

    @JsonProperty("imageSource")
    private String imageSource = null;

    @JsonProperty("requireOcrFlag")
    private Integer requireOcrFlag = null;

    @JsonProperty("fileUrl")
    private String fileUrl = null;

    @JsonProperty("fileUrlHandle")
    private String fileUrlHandle = null;

    @JsonProperty("fileUrlOrigin")
    private String fileUrlOrigin = null;

    @JsonProperty("fileType")
    private String fileType = null;

    @JsonProperty("fileTypeHandle")
    private String fileTypeHandle = null;

    @JsonProperty("billSeq")
    private Long billSeq = null;

    @JsonProperty("fileOrder")
    private String fileOrder = null;

    @JsonProperty("fileLevel")
    private Integer fileLevel = null;

    @JsonProperty("recStatus")
    private Integer recStatus = null;

    @JsonProperty("taskId")
    private String taskId = null;

    @JsonProperty("copyCount")
    private Integer copyCount = null;

    @JsonProperty("recStartTime")
    private Long recStartTime = null;

    @JsonProperty("recEndTime")
    private Long recEndTime = null;

    @JsonProperty("billImageId")
    private Long billImageId = null;

    @JsonProperty("ticketImageId")
    private Long ticketImageId = null;

    @JsonProperty("status")
    private Integer status = null;

    @JsonProperty("isManualUnhook")
    private Integer isManualUnhook = null;

    @JsonProperty("isPublic")
    private Integer isPublic = null;

    @JsonProperty("exceptionStatus")
    private Integer exceptionStatus = null;

    @JsonProperty("returnStatus")
    private Integer returnStatus = null;

    @JsonProperty("returnReason")
    private Integer returnReason = null;

    @JsonProperty("returnRemark")
    private String returnRemark = null;

    @JsonProperty("createTime")
    private Long createTime = null;

    @JsonProperty("createUserId")
    private Long createUserId = null;

    @JsonProperty("createUserName")
    private String createUserName = null;

    @JsonProperty("updateTime")
    private Long updateTime = null;

    @JsonProperty("updateUserId")
    private Long updateUserId = null;

    @JsonProperty("updateUserName")
    private String updateUserName = null;

    @JsonProperty("reserved1")
    private String reserved1 = null;

    @JsonProperty("reserved2")
    private String reserved2 = null;

    @JsonProperty("reserved3")
    private String reserved3 = null;

    @JsonProperty("isReuse")
    private Integer isReuse = null;

    @JsonProperty("pageCode")
    private String pageCode = null;

    @JsonProperty("billEntityCode")
    private String billEntityCode = null;

    @JsonProperty("createUserCode")
    private String createUserCode = null;

    @JsonProperty("moreFileUrl")
    private String moreFileUrl = null;

    @JsonProperty("exceptionInfo")
    private String exceptionInfo = null;

    @JsonProperty("warningInfo")
    private String warningInfo = null;

    @JsonProperty("relExceptionInfo")
    private String relExceptionInfo = null;

    @JsonProperty("relWarningInfo")
    private String relWarningInfo = null;

    @JsonProperty("isCommit")
    private Integer isCommit = null;

    @JsonProperty("commitUserId")
    private Long commitUserId = null;

    @JsonProperty("commitUserName")
    private String commitUserName = null;

    @JsonProperty("commitTime")
    private Long commitTime = null;

    @JsonProperty("isHang")
    private Integer isHang = null;

    @JsonProperty("returnType")
    private Integer returnType = null;

    @JsonProperty("fileName")
    private String fileName = null;

    @JsonProperty("orgId")
    private Long orgId = null;

    @JsonProperty("orgCode")
    private String orgCode = null;

    @JsonProperty("orgName")
    private String orgName = null;

    @JsonProperty("calculateStatus")
    private Integer calculateStatus = null;

    @JsonProperty("ticketCode")
    private String ticketCode = null;

    @JsonProperty("ticketName")
    private String ticketName = null;

    @JsonProperty("isAdd")
    private Integer isAdd = null;

    @JsonProperty("isChange")
    private Integer isChange = null;

    @JsonProperty("isReplace")
    private Integer isReplace = null;

    @JsonProperty("fileId")
    private Long fileId = null;

    @Description("稽核扫描匹配字段")
    private String compareScanMatchField;

    @Description("终审退回状态")
    private Integer auditBackStatus;

    @Description("含税金额")
    private String taxAmount;

    @Description("不含税金额")
    private String amountWithTax;

    @Description("流水号")
    private String serialNumber;

    public String getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(String taxAmount) {
        this.taxAmount = taxAmount;
    }

    public String getAmountWithTax() {
        return amountWithTax;
    }

    public void setAmountWithTax(String amountWithTax) {
        this.amountWithTax = amountWithTax;
    }

    public String getSerialNumber() {
        return serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    @JsonIgnore
    public ImageDTO id(Long id) {
        this.id = id;
        return this;
    }


    public Integer getIsReplace() {
        return isReplace;
    }

    public void setIsReplace(Integer isReplace) {
        this.isReplace = isReplace;
    }

    /**
     * 自增主键
     *
     * @return id
     **/
    @ApiModelProperty(value = "自增主键")
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    public ImageDTO tenantId(Long tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    /**
     * 租户ID
     *
     * @return tenantId
     **/
    @ApiModelProperty(value = "租户ID")
    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    @JsonIgnore
    public ImageDTO billCode(String billCode) {
        this.billCode = billCode;
        return this;
    }

    /**
     * 单据code
     *
     * @return billCode
     **/
    @ApiModelProperty(value = "单据code")
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @JsonIgnore
    public ImageDTO batchNo(String batchNo) {
        this.batchNo = batchNo;
        return this;
    }

    /**
     * 扫描批次号
     *
     * @return batchNo
     **/
    @ApiModelProperty(value = "扫描批次号")
    public String getBatchNo() {
        return batchNo;
    }

    public void setBatchNo(String batchNo) {
        this.batchNo = batchNo;
    }

    @JsonIgnore
    public ImageDTO imageCategory(Integer imageCategory) {
        this.imageCategory = imageCategory;
        return this;
    }

    /**
     * 影像大类别：0-未识别类型，1-封面（结算单），2-大发票（单张），3-小发票（多张），4-裸扫大发票（单张），5-附件
     *
     * @return imageCategory
     **/
    @ApiModelProperty(value = "影像大类别：0-未识别类型，1-封面（结算单），2-大发票（单张），3-小发票（多张），4-裸扫大发票（单张），5-附件")
    public Integer getImageCategory() {
        return imageCategory;
    }

    public void setImageCategory(Integer imageCategory) {
        this.imageCategory = imageCategory;
    }

    @JsonIgnore
    public ImageDTO imageType(Integer imageType) {
        this.imageType = imageType;
        return this;
    }

    /**
     * 业务类型：1-单据，2-发票，3-附件，99-其他
     *
     * @return imageType
     **/
    @ApiModelProperty(value = "业务类型：1-单据，2-发票，3-附件，99-其他")
    public Integer getImageType() {
        return imageType;
    }

    public void setImageType(Integer imageType) {
        this.imageType = imageType;
    }

    @JsonIgnore
    public ImageDTO imageSource(String imageSource) {
        this.imageSource = imageSource;
        return this;
    }

    /**
     * 来源：1-扫描，2-上传，3-接口，99-其他
     *
     * @return imageSource
     **/
    @ApiModelProperty(value = "来源：1-扫描，2-上传，3-接口，99-其他")
    public String getImageSource() {
        return imageSource;
    }

    public void setImageSource(String imageSource) {
        this.imageSource = imageSource;
    }

    @JsonIgnore
    public ImageDTO requireOcrFlag(Integer requireOcrFlag) {
        this.requireOcrFlag = requireOcrFlag;
        return this;
    }

    /**
     * 是否需要识别：1-需要，0-不需要
     *
     * @return requireOcrFlag
     **/
    @ApiModelProperty(value = "是否需要识别：1-需要，0-不需要")
    public Integer getRequireOcrFlag() {
        return requireOcrFlag;
    }

    public void setRequireOcrFlag(Integer requireOcrFlag) {
        this.requireOcrFlag = requireOcrFlag;
    }

    @JsonIgnore
    public ImageDTO fileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
        return this;
    }

    /**
     * 原始文件路径
     *
     * @return fileUrl
     **/
    @ApiModelProperty(value = "原始文件路径")
    public String getFileUrl() {
        return fileUrl;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    @JsonIgnore
    public ImageDTO fileUrlHandle(String fileUrlHandle) {
        this.fileUrlHandle = fileUrlHandle;
        return this;
    }

    /**
     * 处理文件路径
     *
     * @return fileUrlHandle
     **/
    @ApiModelProperty(value = "处理文件路径")
    public String getFileUrlHandle() {
        return fileUrlHandle;
    }

    public void setFileUrlHandle(String fileUrlHandle) {
        this.fileUrlHandle = fileUrlHandle;
    }

    @JsonIgnore
    public ImageDTO fileUrlOrigin(String fileUrlOrigin) {
        this.fileUrlOrigin = fileUrlOrigin;
        return this;
    }

    /**
     * 原处理文件路径
     *
     * @return fileUrlOrigin
     **/
    @ApiModelProperty(value = "原处理文件路径")
    public String getFileUrlOrigin() {
        return fileUrlOrigin;
    }

    public void setFileUrlOrigin(String fileUrlOrigin) {
        this.fileUrlOrigin = fileUrlOrigin;
    }

    @JsonIgnore
    public ImageDTO fileType(String fileType) {
        this.fileType = fileType;
        return this;
    }

    /**
     * 原始文件类型：PNG-PNG,JPG-JPG,JPEG-JPEG,PDF-PDF
     *
     * @return fileType
     **/
    @ApiModelProperty(value = "原始文件类型：PNG-PNG,JPG-JPG,JPEG-JPEG,PDF-PDF")
    public String getFileType() {
        return fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    @JsonIgnore
    public ImageDTO fileTypeHandle(String fileTypeHandle) {
        this.fileTypeHandle = fileTypeHandle;
        return this;
    }

    /**
     * 处理文件类型（如pdf转换为图片）：文件类型：PNG-PNG,JPG-JPG,JPEG-JPEG,PDF-PDF
     *
     * @return fileTypeHandle
     **/
    @ApiModelProperty(value = "处理文件类型（如pdf转换为图片）：文件类型：PNG-PNG,JPG-JPG,JPEG-JPEG,PDF-PDF")
    public String getFileTypeHandle() {
        return fileTypeHandle;
    }

    public void setFileTypeHandle(String fileTypeHandle) {
        this.fileTypeHandle = fileTypeHandle;
    }

    @JsonIgnore
    public ImageDTO billSeq(Long billSeq) {
        this.billSeq = billSeq;
        return this;
    }

    /**
     * 影像提交序列
     *
     * @return billSeq
     **/
    @ApiModelProperty(value = "影像提交序列")
    public Long getBillSeq() {
        return billSeq;
    }

    public void setBillSeq(Long billSeq) {
        this.billSeq = billSeq;
    }

    @JsonIgnore
    public ImageDTO fileOrder(String fileOrder) {
        this.fileOrder = fileOrder;
        return this;
    }

    /**
     * 文件顺序
     *
     * @return fileOrder
     **/
    @ApiModelProperty(value = "文件顺序")
    public String getFileOrder() {
        return fileOrder;
    }

    public void setFileOrder(String fileOrder) {
        this.fileOrder = fileOrder;
    }

    @JsonIgnore
    public ImageDTO fileLevel(Integer fileLevel) {
        this.fileLevel = fileLevel;
        return this;
    }

    /**
     * 文件level
     *
     * @return fileLevel
     **/
    @ApiModelProperty(value = "文件level")
    public Integer getFileLevel() {
        return fileLevel;
    }

    public void setFileLevel(Integer fileLevel) {
        this.fileLevel = fileLevel;
    }

    @JsonIgnore
    public ImageDTO recStatus(Integer recStatus) {
        this.recStatus = recStatus;
        return this;
    }

    /**
     * 处理状态：0-未识别,1-正在识别,2-识别完成
     *
     * @return recStatus
     **/
    @ApiModelProperty(value = "处理状态：0-未识别,1-正在识别,2-识别完成")
    public Integer getRecStatus() {
        return recStatus;
    }

    public void setRecStatus(Integer recStatus) {
        this.recStatus = recStatus;
    }

    @JsonIgnore
    public ImageDTO taskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    /**
     * 任务编号，识别任务编号
     *
     * @return taskId
     **/
    @ApiModelProperty(value = "任务编号，识别任务编号")
    public String getTaskId() {
        return taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @JsonIgnore
    public ImageDTO copyCount(Integer copyCount) {
        this.copyCount = copyCount;
        return this;
    }

    /**
     * 副本数量
     *
     * @return copyCount
     **/
    @ApiModelProperty(value = "副本数量")
    public Integer getCopyCount() {
        return copyCount;
    }

    public void setCopyCount(Integer copyCount) {
        this.copyCount = copyCount;
    }

    @JsonIgnore
    public ImageDTO recStartTime(Long recStartTime) {
        this.recStartTime = recStartTime;
        return this;
    }

    /**
     * 识别开始时间
     *
     * @return recStartTime
     **/
    @ApiModelProperty(value = "识别开始时间")
    public Long getRecStartTime() {
        return recStartTime;
    }

    public void setRecStartTime(Long recStartTime) {
        this.recStartTime = recStartTime;
    }

    @JsonIgnore
    public ImageDTO recEndTime(Long recEndTime) {
        this.recEndTime = recEndTime;
        return this;
    }

    /**
     * 识别结束时间
     *
     * @return recEndTime
     **/
    @ApiModelProperty(value = "识别结束时间")
    public Long getRecEndTime() {
        return recEndTime;
    }

    public void setRecEndTime(Long recEndTime) {
        this.recEndTime = recEndTime;
    }

    @JsonIgnore
    public ImageDTO billImageId(Long billImageId) {
        this.billImageId = billImageId;
        return this;
    }

    /**
     * 所属单据的影像ID
     *
     * @return billImageId
     **/
    @ApiModelProperty(value = "所属单据的影像ID")
    public Long getBillImageId() {
        return billImageId;
    }

    public void setBillImageId(Long billImageId) {
        this.billImageId = billImageId;
    }

    @JsonIgnore
    public ImageDTO ticketImageId(Long ticketImageId) {
        this.ticketImageId = ticketImageId;
        return this;
    }

    /**
     * 所属单证的影像ID
     *
     * @return ticketImageId
     **/
    @ApiModelProperty(value = "所属单证的影像ID")
    public Long getTicketImageId() {
        return ticketImageId;
    }

    public void setTicketImageId(Long ticketImageId) {
        this.ticketImageId = ticketImageId;
    }

    @JsonIgnore
    public ImageDTO status(Integer status) {
        this.status = status;
        return this;
    }

    /**
     * 状态：1-正常，0-已删除
     *
     * @return status
     **/
    @ApiModelProperty(value = "状态：1-正常，0-已删除")
    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    @JsonIgnore
    public ImageDTO isManualUnhook(Integer isManualUnhook) {
        this.isManualUnhook = isManualUnhook;
        return this;
    }

    /**
     * 是否手动脱挂：0-否，1-是
     *
     * @return isManualUnhook
     **/
    @ApiModelProperty(value = "是否手动脱挂：0-否，1-是")
    public Integer getIsManualUnhook() {
        return isManualUnhook;
    }

    public void setIsManualUnhook(Integer isManualUnhook) {
        this.isManualUnhook = isManualUnhook;
    }

    @JsonIgnore
    public ImageDTO isPublic(Integer isPublic) {
        this.isPublic = isPublic;
        return this;
    }

    /**
     * 是否公共：0-否，1-是
     *
     * @return isPublic
     **/
    @ApiModelProperty(value = "是否公共：0-否，1-是")
    public Integer getIsPublic() {
        return isPublic;
    }

    public void setIsPublic(Integer isPublic) {
        this.isPublic = isPublic;
    }

    @JsonIgnore
    public ImageDTO exceptionStatus(Integer exceptionStatus) {
        this.exceptionStatus = exceptionStatus;
        return this;
    }

    /**
     * 异常状态：0-无异常，1-异常，2-预警
     *
     * @return exceptionStatus
     **/
    @ApiModelProperty(value = "异常状态：0-无异常，1-异常，2-预警")
    public Integer getExceptionStatus() {
        return exceptionStatus;
    }

    public void setExceptionStatus(Integer exceptionStatus) {
        this.exceptionStatus = exceptionStatus;
    }

    @JsonIgnore
    public ImageDTO returnStatus(Integer returnStatus) {
        this.returnStatus = returnStatus;
        return this;
    }

    /**
     * 退回状态：0-未退回，1-退回，2-已修改
     *
     * @return returnStatus
     **/
    @ApiModelProperty(value = "退回状态：0-未退回，1-退回，2-已修改")
    public Integer getReturnStatus() {
        return returnStatus;
    }

    public void setReturnStatus(Integer returnStatus) {
        this.returnStatus = returnStatus;
    }

    @JsonIgnore
    public ImageDTO returnReason(Integer returnReason) {
        this.returnReason = returnReason;
        return this;
    }

    /**
     * 退回原因：
     *
     * @return returnReason
     **/
    @ApiModelProperty(value = "退回原因：")
    public Integer getReturnReason() {
        return returnReason;
    }

    public void setReturnReason(Integer returnReason) {
        this.returnReason = returnReason;
    }

    @JsonIgnore
    public ImageDTO returnRemark(String returnRemark) {
        this.returnRemark = returnRemark;
        return this;
    }

    /**
     * 退回备注
     *
     * @return returnRemark
     **/
    @ApiModelProperty(value = "退回备注")
    public String getReturnRemark() {
        return returnRemark;
    }

    public void setReturnRemark(String returnRemark) {
        this.returnRemark = returnRemark;
    }

    @JsonIgnore
    public ImageDTO createTime(Long createTime) {
        this.createTime = createTime;
        return this;
    }

    /**
     * 创建时间
     *
     * @return createTime
     **/
    @ApiModelProperty(value = "创建时间")
    public Long getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    @JsonIgnore
    public ImageDTO createUserId(Long createUserId) {
        this.createUserId = createUserId;
        return this;
    }

    /**
     * 创建人ID
     *
     * @return createUserId
     **/
    @ApiModelProperty(value = "创建人ID")
    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    @JsonIgnore
    public ImageDTO createUserName(String createUserName) {
        this.createUserName = createUserName;
        return this;
    }

    /**
     * 创建人姓名
     *
     * @return createUserName
     **/
    @ApiModelProperty(value = "创建人姓名")
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    @JsonIgnore
    public ImageDTO updateTime(Long updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    /**
     * 更新时间
     *
     * @return updateTime
     **/
    @ApiModelProperty(value = "更新时间")
    public Long getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
    }

    @JsonIgnore
    public ImageDTO updateUserId(Long updateUserId) {
        this.updateUserId = updateUserId;
        return this;
    }

    /**
     * 更新人ID
     *
     * @return updateUserId
     **/
    @ApiModelProperty(value = "更新人ID")
    public Long getUpdateUserId() {
        return updateUserId;
    }

    public void setUpdateUserId(Long updateUserId) {
        this.updateUserId = updateUserId;
    }

    @JsonIgnore
    public ImageDTO updateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
        return this;
    }

    /**
     * 更新人姓名
     *
     * @return updateUserName
     **/
    @ApiModelProperty(value = "更新人姓名")
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    @JsonIgnore
    public ImageDTO reserved1(String reserved1) {
        this.reserved1 = reserved1;
        return this;
    }

    /**
     * 保留字段
     *
     * @return reserved1
     **/
    @ApiModelProperty(value = "保留字段")
    public String getReserved1() {
        return reserved1;
    }

    public void setReserved1(String reserved1) {
        this.reserved1 = reserved1;
    }

    @JsonIgnore
    public ImageDTO reserved2(String reserved2) {
        this.reserved2 = reserved2;
        return this;
    }

    /**
     * 保留字段
     *
     * @return reserved2
     **/
    @ApiModelProperty(value = "保留字段")
    public String getReserved2() {
        return reserved2;
    }

    public void setReserved2(String reserved2) {
        this.reserved2 = reserved2;
    }

    @JsonIgnore
    public ImageDTO reserved3(String reserved3) {
        this.reserved3 = reserved3;
        return this;
    }

    /**
     * 保留字段
     *
     * @return reserved3
     **/
    @ApiModelProperty(value = "保留字段")
    public String getReserved3() {
        return reserved3;
    }

    public void setReserved3(String reserved3) {
        this.reserved3 = reserved3;
    }

    @JsonIgnore
    public ImageDTO isReuse(Integer isReuse) {
        this.isReuse = isReuse;
        return this;
    }

    /**
     * 是否复用:0-否,1-是
     *
     * @return isReuse
     **/
    @ApiModelProperty(value = "是否复用:0-否,1-是")
    public Integer getIsReuse() {
        return isReuse;
    }

    public void setIsReuse(Integer isReuse) {
        this.isReuse = isReuse;
    }

    @JsonIgnore
    public ImageDTO pageCode(String pageCode) {
        this.pageCode = pageCode;
        return this;
    }

    /**
     * 上传所属页面
     *
     * @return pageCode
     **/
    @ApiModelProperty(value = "上传所属页面")
    public String getPageCode() {
        return pageCode;
    }

    public void setPageCode(String pageCode) {
        this.pageCode = pageCode;
    }

    @JsonIgnore
    public ImageDTO billEntityCode(String billEntityCode) {
        this.billEntityCode = billEntityCode;
        return this;
    }

    /**
     * 上传所属单据对象
     *
     * @return billEntityCode
     **/
    @ApiModelProperty(value = "上传所属单据对象")
    public String getBillEntityCode() {
        return billEntityCode;
    }

    public void setBillEntityCode(String billEntityCode) {
        this.billEntityCode = billEntityCode;
    }

    @JsonIgnore
    public ImageDTO createUserCode(String createUserCode) {
        this.createUserCode = createUserCode;
        return this;
    }

    /**
     * 创建人代码
     *
     * @return createUserCode
     **/
    @ApiModelProperty(value = "创建人代码")
    public String getCreateUserCode() {
        return createUserCode;
    }

    public void setCreateUserCode(String createUserCode) {
        this.createUserCode = createUserCode;
    }

    @JsonIgnore
    public ImageDTO moreFileUrl(String moreFileUrl) {
        this.moreFileUrl = moreFileUrl;
        return this;
    }

    /**
     * 多票地址
     *
     * @return moreFileUrl
     **/
    @ApiModelProperty(value = "多票地址")
    public String getMoreFileUrl() {
        return moreFileUrl;
    }

    public void setMoreFileUrl(String moreFileUrl) {
        this.moreFileUrl = moreFileUrl;
    }

    @JsonIgnore
    public ImageDTO exceptionInfo(String exceptionInfo) {
        this.exceptionInfo = exceptionInfo;
        return this;
    }

    /**
     * 异常信息
     *
     * @return exceptionInfo
     **/
    @ApiModelProperty(value = "异常信息")
    public String getExceptionInfo() {
        return exceptionInfo;
    }

    public void setExceptionInfo(String exceptionInfo) {
        this.exceptionInfo = exceptionInfo;
    }

    @JsonIgnore
    public ImageDTO warningInfo(String warningInfo) {
        this.warningInfo = warningInfo;
        return this;
    }

    /**
     * 预警信息
     *
     * @return warningInfo
     **/
    @ApiModelProperty(value = "预警信息")
    public String getWarningInfo() {
        return warningInfo;
    }

    public void setWarningInfo(String warningInfo) {
        this.warningInfo = warningInfo;
    }

    @JsonIgnore
    public ImageDTO relExceptionInfo(String relExceptionInfo) {
        this.relExceptionInfo = relExceptionInfo;
        return this;
    }

    /**
     * 挂接异常信息
     *
     * @return relExceptionInfo
     **/
    @ApiModelProperty(value = "挂接异常信息")
    public String getRelExceptionInfo() {
        return relExceptionInfo;
    }

    public void setRelExceptionInfo(String relExceptionInfo) {
        this.relExceptionInfo = relExceptionInfo;
    }

    @JsonIgnore
    public ImageDTO relWarningInfo(String relWarningInfo) {
        this.relWarningInfo = relWarningInfo;
        return this;
    }

    /**
     * 挂接预警信息
     *
     * @return relWarningInfo
     **/
    @ApiModelProperty(value = "挂接预警信息")
    public String getRelWarningInfo() {
        return relWarningInfo;
    }

    public void setRelWarningInfo(String relWarningInfo) {
        this.relWarningInfo = relWarningInfo;
    }

    @JsonIgnore
    public ImageDTO isCommit(Integer isCommit) {
        this.isCommit = isCommit;
        return this;
    }

    /**
     * 是否提交:0-否,1-是
     *
     * @return isCommit
     **/
    @ApiModelProperty(value = "是否提交:0-否,1-是")
    public Integer getIsCommit() {
        return isCommit;
    }

    public void setIsCommit(Integer isCommit) {
        this.isCommit = isCommit;
    }

    @JsonIgnore
    public ImageDTO commitUserId(Long commitUserId) {
        this.commitUserId = commitUserId;
        return this;
    }

    /**
     * 提交人ID
     *
     * @return commitUserId
     **/
    @ApiModelProperty(value = "提交人ID")
    public Long getCommitUserId() {
        return commitUserId;
    }

    public void setCommitUserId(Long commitUserId) {
        this.commitUserId = commitUserId;
    }

    @JsonIgnore
    public ImageDTO commitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
        return this;
    }

    /**
     * 提交人姓名
     *
     * @return commitUserName
     **/
    @ApiModelProperty(value = "提交人姓名")
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    @JsonIgnore
    public ImageDTO commitTime(Long commitTime) {
        this.commitTime = commitTime;
        return this;
    }

    /**
     * 提交时间
     *
     * @return commitTime
     **/
    @ApiModelProperty(value = "提交时间")
    public Long getCommitTime() {
        return commitTime;
    }

    public void setCommitTime(Long commitTime) {
        this.commitTime = commitTime;
    }

    @JsonIgnore
    public ImageDTO isHang(Integer isHang) {
        this.isHang = isHang;
        return this;
    }

    /**
     * 是否挂起:0-否,1-是
     *
     * @return isHang
     **/
    @ApiModelProperty(value = "是否挂起:0-否,1-是")
    public Integer getIsHang() {
        return isHang;
    }

    public void setIsHang(Integer isHang) {
        this.isHang = isHang;
    }

    @JsonIgnore
    public ImageDTO returnType(Integer returnType) {
        this.returnType = returnType;
        return this;
    }

    /**
     * 退回类型
     *
     * @return returnType
     **/
    @ApiModelProperty(value = "退回类型")
    public Integer getReturnType() {
        return returnType;
    }

    public void setReturnType(Integer returnType) {
        this.returnType = returnType;
    }

    @JsonIgnore
    public ImageDTO fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    /**
     * 文件名
     *
     * @return fileName
     **/
    @ApiModelProperty(value = "文件名")
    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @JsonIgnore
    public ImageDTO orgId(Long orgId) {
        this.orgId = orgId;
        return this;
    }

    /**
     * 组织id
     *
     * @return orgId
     **/
    @ApiModelProperty(value = "组织id")
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    @JsonIgnore
    public ImageDTO orgCode(String orgCode) {
        this.orgCode = orgCode;
        return this;
    }

    /**
     * 组织代码
     *
     * @return orgCode
     **/
    @ApiModelProperty(value = "组织代码")
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    @JsonIgnore
    public ImageDTO orgName(String orgName) {
        this.orgName = orgName;
        return this;
    }

    /**
     * 组织名称
     *
     * @return orgName
     **/
    @ApiModelProperty(value = "组织名称")
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @JsonIgnore
    public ImageDTO calculateStatus(Integer calculateStatus) {
        this.calculateStatus = calculateStatus;
        return this;
    }

    /**
     * 计算状态
     *
     * @return calculateStatus
     **/
    @ApiModelProperty(value = "计算状态")
    public Integer getCalculateStatus() {
        return calculateStatus;
    }

    public void setCalculateStatus(Integer calculateStatus) {
        this.calculateStatus = calculateStatus;
    }

    @JsonIgnore
    public ImageDTO ticketCode(String ticketCode) {
        this.ticketCode = ticketCode;
        return this;
    }

    /**
     * 单证类型
     *
     * @return ticketCode
     **/
    @ApiModelProperty(value = "单证类型")
    public String getTicketCode() {
        return ticketCode;
    }

    public void setTicketCode(String ticketCode) {
        this.ticketCode = ticketCode;
    }

    @JsonIgnore
    public ImageDTO ticketName(String ticketName) {
        this.ticketName = ticketName;
        return this;
    }

    /**
     * 单证类型名称
     *
     * @return ticketName
     **/
    @ApiModelProperty(value = "单证类型名称")
    public String getTicketName() {
        return ticketName;
    }

    public void setTicketName(String ticketName) {
        this.ticketName = ticketName;
    }

    @JsonIgnore
    public ImageDTO isAdd(Integer isAdd) {
        this.isAdd = isAdd;
        return this;
    }

    /**
     * null
     *
     * @return isAdd
     **/
    @ApiModelProperty(value = "null")
    public Integer getIsAdd() {
        return isAdd;
    }

    public void setIsAdd(Integer isAdd) {
        this.isAdd = isAdd;
    }

    @JsonIgnore
    public ImageDTO isChange(Integer isChange) {
        this.isChange = isChange;
        return this;
    }

    /**
     * null
     *
     * @return isChange
     **/
    @ApiModelProperty(value = "null")
    public Integer getIsChange() {
        return isChange;
    }

    public void setIsChange(Integer isChange) {
        this.isChange = isChange;
    }

    @JsonIgnore
    public ImageDTO fileId(Long fileId) {
        this.fileId = fileId;
        return this;
    }

    /**
     * 文件ID
     *
     * @return fileId
     **/
    @ApiModelProperty(value = "文件ID")
    public Long getFileId() {
        return fileId;
    }

    public void setFileId(Long fileId) {
        this.fileId = fileId;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ImageDTO imageDTO = (ImageDTO) o;
        return Objects.equals(this.id, imageDTO.id) &&
            Objects.equals(this.tenantId, imageDTO.tenantId) &&
            Objects.equals(this.billCode, imageDTO.billCode) &&
            Objects.equals(this.batchNo, imageDTO.batchNo) &&
            Objects.equals(this.imageCategory, imageDTO.imageCategory) &&
            Objects.equals(this.imageType, imageDTO.imageType) &&
            Objects.equals(this.imageSource, imageDTO.imageSource) &&
            Objects.equals(this.requireOcrFlag, imageDTO.requireOcrFlag) &&
            Objects.equals(this.fileUrl, imageDTO.fileUrl) &&
            Objects.equals(this.fileUrlHandle, imageDTO.fileUrlHandle) &&
            Objects.equals(this.fileUrlOrigin, imageDTO.fileUrlOrigin) &&
            Objects.equals(this.fileType, imageDTO.fileType) &&
            Objects.equals(this.fileTypeHandle, imageDTO.fileTypeHandle) &&
            Objects.equals(this.billSeq, imageDTO.billSeq) &&
            Objects.equals(this.fileOrder, imageDTO.fileOrder) &&
            Objects.equals(this.fileLevel, imageDTO.fileLevel) &&
            Objects.equals(this.recStatus, imageDTO.recStatus) &&
            Objects.equals(this.taskId, imageDTO.taskId) &&
            Objects.equals(this.copyCount, imageDTO.copyCount) &&
            Objects.equals(this.recStartTime, imageDTO.recStartTime) &&
            Objects.equals(this.recEndTime, imageDTO.recEndTime) &&
            Objects.equals(this.billImageId, imageDTO.billImageId) &&
            Objects.equals(this.ticketImageId, imageDTO.ticketImageId) &&
            Objects.equals(this.status, imageDTO.status) &&
            Objects.equals(this.isManualUnhook, imageDTO.isManualUnhook) &&
            Objects.equals(this.isPublic, imageDTO.isPublic) &&
            Objects.equals(this.exceptionStatus, imageDTO.exceptionStatus) &&
            Objects.equals(this.returnStatus, imageDTO.returnStatus) &&
            Objects.equals(this.returnReason, imageDTO.returnReason) &&
            Objects.equals(this.returnRemark, imageDTO.returnRemark) &&
            Objects.equals(this.createTime, imageDTO.createTime) &&
            Objects.equals(this.createUserId, imageDTO.createUserId) &&
            Objects.equals(this.createUserName, imageDTO.createUserName) &&
            Objects.equals(this.updateTime, imageDTO.updateTime) &&
            Objects.equals(this.updateUserId, imageDTO.updateUserId) &&
            Objects.equals(this.updateUserName, imageDTO.updateUserName) &&
            Objects.equals(this.reserved1, imageDTO.reserved1) &&
            Objects.equals(this.reserved2, imageDTO.reserved2) &&
            Objects.equals(this.reserved3, imageDTO.reserved3) &&
            Objects.equals(this.isReuse, imageDTO.isReuse) &&
            Objects.equals(this.pageCode, imageDTO.pageCode) &&
            Objects.equals(this.billEntityCode, imageDTO.billEntityCode) &&
            Objects.equals(this.createUserCode, imageDTO.createUserCode) &&
            Objects.equals(this.moreFileUrl, imageDTO.moreFileUrl) &&
            Objects.equals(this.exceptionInfo, imageDTO.exceptionInfo) &&
            Objects.equals(this.warningInfo, imageDTO.warningInfo) &&
            Objects.equals(this.relExceptionInfo, imageDTO.relExceptionInfo) &&
            Objects.equals(this.relWarningInfo, imageDTO.relWarningInfo) &&
            Objects.equals(this.isCommit, imageDTO.isCommit) &&
            Objects.equals(this.commitUserId, imageDTO.commitUserId) &&
            Objects.equals(this.commitUserName, imageDTO.commitUserName) &&
            Objects.equals(this.commitTime, imageDTO.commitTime) &&
            Objects.equals(this.isHang, imageDTO.isHang) &&
            Objects.equals(this.returnType, imageDTO.returnType) &&
            Objects.equals(this.fileName, imageDTO.fileName) &&
            Objects.equals(this.orgId, imageDTO.orgId) &&
            Objects.equals(this.orgCode, imageDTO.orgCode) &&
            Objects.equals(this.orgName, imageDTO.orgName) &&
            Objects.equals(this.calculateStatus, imageDTO.calculateStatus) &&
            Objects.equals(this.ticketCode, imageDTO.ticketCode) &&
            Objects.equals(this.ticketName, imageDTO.ticketName) &&
            Objects.equals(this.isAdd, imageDTO.isAdd) &&
            Objects.equals(this.isChange, imageDTO.isChange) &&
            Objects.equals(this.fileId, imageDTO.fileId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, tenantId, billCode, batchNo, imageCategory, imageType, imageSource, requireOcrFlag, fileUrl, fileUrlHandle, fileUrlOrigin, fileType, fileTypeHandle, billSeq, fileOrder,
            fileLevel, recStatus, taskId, copyCount, recStartTime, recEndTime, billImageId, ticketImageId, status, isManualUnhook, isPublic, exceptionStatus, returnStatus, returnReason, returnRemark,
            createTime, createUserId, createUserName, updateTime, updateUserId, updateUserName, reserved1, reserved2, reserved3, isReuse, pageCode, billEntityCode, createUserCode, moreFileUrl,
            exceptionInfo, warningInfo, relExceptionInfo, relWarningInfo, isCommit, commitUserId, commitUserName, commitTime, isHang, returnType, fileName, orgId, orgCode, orgName, calculateStatus,
            ticketCode, ticketName, isAdd, isChange, fileId);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImageDTO {\n");

        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
        sb.append("    billCode: ").append(toIndentedString(billCode)).append("\n");
        sb.append("    batchNo: ").append(toIndentedString(batchNo)).append("\n");
        sb.append("    imageCategory: ").append(toIndentedString(imageCategory)).append("\n");
        sb.append("    imageType: ").append(toIndentedString(imageType)).append("\n");
        sb.append("    imageSource: ").append(toIndentedString(imageSource)).append("\n");
        sb.append("    requireOcrFlag: ").append(toIndentedString(requireOcrFlag)).append("\n");
        sb.append("    fileUrl: ").append(toIndentedString(fileUrl)).append("\n");
        sb.append("    fileUrlHandle: ").append(toIndentedString(fileUrlHandle)).append("\n");
        sb.append("    fileUrlOrigin: ").append(toIndentedString(fileUrlOrigin)).append("\n");
        sb.append("    fileType: ").append(toIndentedString(fileType)).append("\n");
        sb.append("    fileTypeHandle: ").append(toIndentedString(fileTypeHandle)).append("\n");
        sb.append("    billSeq: ").append(toIndentedString(billSeq)).append("\n");
        sb.append("    fileOrder: ").append(toIndentedString(fileOrder)).append("\n");
        sb.append("    fileLevel: ").append(toIndentedString(fileLevel)).append("\n");
        sb.append("    recStatus: ").append(toIndentedString(recStatus)).append("\n");
        sb.append("    taskId: ").append(toIndentedString(taskId)).append("\n");
        sb.append("    copyCount: ").append(toIndentedString(copyCount)).append("\n");
        sb.append("    recStartTime: ").append(toIndentedString(recStartTime)).append("\n");
        sb.append("    recEndTime: ").append(toIndentedString(recEndTime)).append("\n");
        sb.append("    billImageId: ").append(toIndentedString(billImageId)).append("\n");
        sb.append("    ticketImageId: ").append(toIndentedString(ticketImageId)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    isManualUnhook: ").append(toIndentedString(isManualUnhook)).append("\n");
        sb.append("    isPublic: ").append(toIndentedString(isPublic)).append("\n");
        sb.append("    exceptionStatus: ").append(toIndentedString(exceptionStatus)).append("\n");
        sb.append("    returnStatus: ").append(toIndentedString(returnStatus)).append("\n");
        sb.append("    returnReason: ").append(toIndentedString(returnReason)).append("\n");
        sb.append("    returnRemark: ").append(toIndentedString(returnRemark)).append("\n");
        sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
        sb.append("    createUserId: ").append(toIndentedString(createUserId)).append("\n");
        sb.append("    createUserName: ").append(toIndentedString(createUserName)).append("\n");
        sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
        sb.append("    updateUserId: ").append(toIndentedString(updateUserId)).append("\n");
        sb.append("    updateUserName: ").append(toIndentedString(updateUserName)).append("\n");
        sb.append("    reserved1: ").append(toIndentedString(reserved1)).append("\n");
        sb.append("    reserved2: ").append(toIndentedString(reserved2)).append("\n");
        sb.append("    reserved3: ").append(toIndentedString(reserved3)).append("\n");
        sb.append("    isReuse: ").append(toIndentedString(isReuse)).append("\n");
        sb.append("    pageCode: ").append(toIndentedString(pageCode)).append("\n");
        sb.append("    billEntityCode: ").append(toIndentedString(billEntityCode)).append("\n");
        sb.append("    createUserCode: ").append(toIndentedString(createUserCode)).append("\n");
        sb.append("    moreFileUrl: ").append(toIndentedString(moreFileUrl)).append("\n");
        sb.append("    exceptionInfo: ").append(toIndentedString(exceptionInfo)).append("\n");
        sb.append("    warningInfo: ").append(toIndentedString(warningInfo)).append("\n");
        sb.append("    relExceptionInfo: ").append(toIndentedString(relExceptionInfo)).append("\n");
        sb.append("    relWarningInfo: ").append(toIndentedString(relWarningInfo)).append("\n");
        sb.append("    isCommit: ").append(toIndentedString(isCommit)).append("\n");
        sb.append("    commitUserId: ").append(toIndentedString(commitUserId)).append("\n");
        sb.append("    commitUserName: ").append(toIndentedString(commitUserName)).append("\n");
        sb.append("    commitTime: ").append(toIndentedString(commitTime)).append("\n");
        sb.append("    isHang: ").append(toIndentedString(isHang)).append("\n");
        sb.append("    returnType: ").append(toIndentedString(returnType)).append("\n");
        sb.append("    fileName: ").append(toIndentedString(fileName)).append("\n");
        sb.append("    orgId: ").append(toIndentedString(orgId)).append("\n");
        sb.append("    orgCode: ").append(toIndentedString(orgCode)).append("\n");
        sb.append("    orgName: ").append(toIndentedString(orgName)).append("\n");
        sb.append("    calculateStatus: ").append(toIndentedString(calculateStatus)).append("\n");
        sb.append("    ticketCode: ").append(toIndentedString(ticketCode)).append("\n");
        sb.append("    ticketName: ").append(toIndentedString(ticketName)).append("\n");
        sb.append("    isAdd: ").append(toIndentedString(isAdd)).append("\n");
        sb.append("    isChange: ").append(toIndentedString(isChange)).append("\n");
        sb.append("    fileId: ").append(toIndentedString(fileId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String getCompareScanMatchField() {
        return compareScanMatchField;
    }

    public void setCompareScanMatchField(String compareScanMatchField) {
        this.compareScanMatchField = compareScanMatchField;
    }

    public Integer getAuditBackStatus() {
        return auditBackStatus;
    }

    public void setAuditBackStatus(Integer auditBackStatus) {
        this.auditBackStatus = auditBackStatus;
    }

}
