package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * InsertImageRequest
 */

@JsonInclude(NON_NULL)
public class InsertImageRequest extends BaseRequest {

    @JsonProperty("billCode")
    private String billCode = null;

    @JsonProperty("parentImageId")
    private Long parentImageId = null;

    @JsonProperty("entities")
    private List<ImageInsertDTO> entities = new ArrayList<ImageInsertDTO>();

    @JsonProperty("ext")
    private JSONObject ext = null;

    @JsonIgnore
    public InsertImageRequest billCode(String billCode) {
        this.billCode = billCode;
        return this;
    }

    /**
     * 业务单code
     *
     * @return billCode
     **/
    @ApiModelProperty(value = "业务单code")
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @JsonIgnore
    public InsertImageRequest parentImageId(Long parentImageId) {
        this.parentImageId = parentImageId;
        return this;
    }

    /**
     * 父影像id
     *
     * @return parentImageId
     **/
    @ApiModelProperty(value = "父影像id")
    public Long getParentImageId() {
        return parentImageId;
    }

    public void setParentImageId(Long parentImageId) {
        this.parentImageId = parentImageId;
    }

    @JsonIgnore
    public InsertImageRequest entities(List<ImageInsertDTO> entities) {
        this.entities = entities;
        return this;
    }

    public InsertImageRequest addEntitiesItem(ImageInsertDTO entitiesItem) {
        this.entities.add(entitiesItem);
        return this;
    }

    /**
     * Get entities
     *
     * @return entities
     **/
    @ApiModelProperty(value = "")
    public List<ImageInsertDTO> getEntities() {
        return entities;
    }

    public void setEntities(List<ImageInsertDTO> entities) {
        this.entities = entities;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        InsertImageRequest insertImageRequest = (InsertImageRequest) o;
        return Objects.equals(this.billCode, insertImageRequest.billCode) &&
            Objects.equals(this.parentImageId, insertImageRequest.parentImageId) &&
            Objects.equals(this.entities, insertImageRequest.entities) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(billCode, parentImageId, entities, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InsertImageRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    billCode: ").append(toIndentedString(billCode)).append("\n");
        sb.append("    parentImageId: ").append(toIndentedString(parentImageId)).append("\n");
        sb.append("    entities: ").append(toIndentedString(entities)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public JSONObject getExt() {
        return ext;
    }

    public void setExt(JSONObject ext) {
        this.ext = ext;
    }

}
