package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/**
 * MoveImageRequest
 */

@JsonInclude(NON_NULL)
public class MoveImageRequest extends BaseRequest {

    @JsonProperty("billCode")
    private String billCode = null;

    @JsonProperty("fileOrder")
    private Integer fileOrder = null;

    @JsonIgnore
    public MoveImageRequest billCode(String billCode) {
        this.billCode = billCode;
        return this;
    }

    /**
     * 业务单code
     *
     * @return billCode
     **/
    @ApiModelProperty(value = "业务单code")
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @JsonIgnore
    public MoveImageRequest fileOrder(Integer fileOrder) {
        this.fileOrder = fileOrder;
        return this;
    }

    /**
     * 顺序
     *
     * @return fileOrder
     **/
    @ApiModelProperty(value = "顺序")
    public Integer getFileOrder() {
        return fileOrder;
    }

    public void setFileOrder(Integer fileOrder) {
        this.fileOrder = fileOrder;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MoveImageRequest moveImageRequest = (MoveImageRequest) o;
        return Objects.equals(this.billCode, moveImageRequest.billCode) &&
            Objects.equals(this.fileOrder, moveImageRequest.fileOrder) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(billCode, fileOrder, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MoveImageRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    billCode: ").append(toIndentedString(billCode)).append("\n");
        sb.append("    fileOrder: ").append(toIndentedString(fileOrder)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
