package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 退回影像Request
 */
@ApiModel(description = "退回影像Request")

@JsonInclude(NON_NULL)
public class ReturnImageRequest extends BaseRequest {

    @JsonProperty("imageIds")
    private List<Long> imageIds = new ArrayList<Long>();

    @JsonProperty("billCode")
    private String billCode = null;

    @JsonProperty("returnReason")
    private Integer returnReason = null;

    @JsonProperty("returnRemark")
    private String returnRemark = null;

    @JsonIgnore
    public ReturnImageRequest imageIds(List<Long> imageIds) {
        this.imageIds = imageIds;
        return this;
    }

    public ReturnImageRequest addImageIdsItem(Long imageIdsItem) {
        this.imageIds.add(imageIdsItem);
        return this;
    }

    /**
     * 影像ids
     *
     * @return imageIds
     **/
    @ApiModelProperty(value = "影像ids")
    public List<Long> getImageIds() {
        return imageIds;
    }

    public void setImageIds(List<Long> imageIds) {
        this.imageIds = imageIds;
    }

    @JsonIgnore
    public ReturnImageRequest billCode(String billCode) {
        this.billCode = billCode;
        return this;
    }

    /**
     * 单据code
     *
     * @return billCode
     **/
    @ApiModelProperty(value = "单据code")
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @JsonIgnore
    public ReturnImageRequest returnReason(Integer returnReason) {
        this.returnReason = returnReason;
        return this;
    }

    /**
     * 退回原因
     *
     * @return returnReason
     **/
    @ApiModelProperty(value = "退回原因")
    public Integer getReturnReason() {
        return returnReason;
    }

    public void setReturnReason(Integer returnReason) {
        this.returnReason = returnReason;
    }

    @JsonIgnore
    public ReturnImageRequest returnRemark(String returnRemark) {
        this.returnRemark = returnRemark;
        return this;
    }

    /**
     * 退回备注
     *
     * @return returnRemark
     **/
    @ApiModelProperty(value = "退回备注")
    public String getReturnRemark() {
        return returnRemark;
    }

    public void setReturnRemark(String returnRemark) {
        this.returnRemark = returnRemark;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ReturnImageRequest returnImageRequest = (ReturnImageRequest) o;
        return Objects.equals(this.imageIds, returnImageRequest.imageIds) &&
            Objects.equals(this.billCode, returnImageRequest.billCode) &&
            Objects.equals(this.returnReason, returnImageRequest.returnReason) &&
            Objects.equals(this.returnRemark, returnImageRequest.returnRemark) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(imageIds, billCode, returnReason, returnRemark, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReturnImageRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    imageIds: ").append(toIndentedString(imageIds)).append("\n");
        sb.append("    billCode: ").append(toIndentedString(billCode)).append("\n");
        sb.append("    returnReason: ").append(toIndentedString(returnReason)).append("\n");
        sb.append("    returnRemark: ").append(toIndentedString(returnRemark)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
