package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 影像表Request
 */
@ApiModel(description = "影像表Request")

@JsonInclude(NON_NULL)
public class SaveImageRequest extends BaseRequest {

    @JsonProperty("isPublic")
    private Integer isPublic = null;

    @JsonProperty("orgId")
    private Long orgId = null;

    @JsonProperty("orgCode")
    private String orgCode = null;

    @JsonProperty("orgName")
    private String orgName = null;

    @JsonProperty("entities")
    private List<ImageDTO> entities = new ArrayList<ImageDTO>();

    @JsonProperty("serialNumber")
    private String serialNumber = null;

    @JsonProperty("billEntityCode")
    private String billEntityCode = null;

    @JsonProperty("ext")
    private JSONObject ext = null;

    @JsonIgnore
    public SaveImageRequest isPublic(Integer isPublic) {
        this.isPublic = isPublic;
        return this;
    }

    /**
     * 是否公共：0-否，1-是
     *
     * @return isPublic
     **/
    @ApiModelProperty(value = "是否公共：0-否，1-是")
    public Integer getIsPublic() {
        return isPublic;
    }

    public void setIsPublic(Integer isPublic) {
        this.isPublic = isPublic;
    }

    @JsonIgnore
    public SaveImageRequest orgId(Long orgId) {
        this.orgId = orgId;
        return this;
    }

    /**
     * 组织id
     *
     * @return orgId
     **/
    @ApiModelProperty(value = "组织id")
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    @JsonIgnore
    public SaveImageRequest orgCode(String orgCode) {
        this.orgCode = orgCode;
        return this;
    }

    /**
     * 组织代码
     *
     * @return orgCode
     **/
    @ApiModelProperty(value = "组织代码")
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    @JsonIgnore
    public SaveImageRequest orgName(String orgName) {
        this.orgName = orgName;
        return this;
    }

    /**
     * 组织名称
     *
     * @return orgName
     **/
    @ApiModelProperty(value = "组织名称")
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @JsonIgnore
    public SaveImageRequest entities(List<ImageDTO> entities) {
        this.entities = entities;
        return this;
    }

    public SaveImageRequest addEntitiesItem(ImageDTO entitiesItem) {
        this.entities.add(entitiesItem);
        return this;
    }

    /**
     * Get entities
     *
     * @return entities
     **/
    @ApiModelProperty(value = "")
    public List<ImageDTO> getEntities() {
        return entities;
    }

    public void setEntities(List<ImageDTO> entities) {
        this.entities = entities;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SaveImageRequest saveImageRequest = (SaveImageRequest) o;
        return Objects.equals(this.isPublic, saveImageRequest.isPublic) &&
            Objects.equals(this.orgId, saveImageRequest.orgId) &&
            Objects.equals(this.orgCode, saveImageRequest.orgCode) &&
            Objects.equals(this.orgName, saveImageRequest.orgName) &&
            Objects.equals(this.entities, saveImageRequest.entities) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(isPublic, orgId, orgCode, orgName, entities, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SaveImageRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    isPublic: ").append(toIndentedString(isPublic)).append("\n");
        sb.append("    orgId: ").append(toIndentedString(orgId)).append("\n");
        sb.append("    orgCode: ").append(toIndentedString(orgCode)).append("\n");
        sb.append("    orgName: ").append(toIndentedString(orgName)).append("\n");
        sb.append("    entities: ").append(toIndentedString(entities)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String getSerialNumber() {
        return serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getBillEntityCode() {
        return billEntityCode;
    }

    public void setBillEntityCode(String billEntityCode) {
        this.billEntityCode = billEntityCode;
    }

    public JSONObject getExt() {
        return ext;
    }

    public void setExt(JSONObject ext) {
        this.ext = ext;
    }

}
