package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/**
 * 查询单证下附件和销货清单
 */
@ApiModel(description = "查询单证下附件和销货清单")

@JsonInclude(NON_NULL)
public class SelectTicketAttachmentRequest extends BaseRequest {

    @JsonProperty("imageId")
    private Long imageId = null;

    @JsonIgnore
    public SelectTicketAttachmentRequest imageId(Long imageId) {
        this.imageId = imageId;
        return this;
    }

    /**
     * 单证的影像ids
     *
     * @return imageId
     **/
    @ApiModelProperty(value = "单证的影像ids")
    public Long getImageId() {
        return imageId;
    }

    public void setImageId(Long imageId) {
        this.imageId = imageId;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SelectTicketAttachmentRequest selectTicketAttachmentRequest = (SelectTicketAttachmentRequest) o;
        return Objects.equals(this.imageId, selectTicketAttachmentRequest.imageId) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(imageId, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SelectTicketAttachmentRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    imageId: ").append(toIndentedString(imageId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
