package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;
import lombok.Data;

/**
 * 发送验真Request
 */
@ApiModel(description = "发送验真Request")
@Data
@JsonInclude(NON_NULL)
public class SendVerifyRequest extends BaseRequest {

    @JsonProperty("ticketId")
    private Long ticketId = null;

    @JsonProperty("ticketIds")
    private List<Long> ticketIds;

    @JsonIgnore
    public SendVerifyRequest ticketId(Long ticketId) {
        this.ticketId = ticketId;
        return this;
    }

    /**
     * 单证主键
     *
     * @return ticketId
     **/
    @ApiModelProperty(value = "单证主键")
    public Long getTicketId() {
        return ticketId;
    }

    public void setTicketId(Long ticketId) {
        this.ticketId = ticketId;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SendVerifyRequest sendVerifyRequest = (SendVerifyRequest) o;
        return Objects.equals(this.ticketId, sendVerifyRequest.ticketId) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(ticketId, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SendVerifyRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    ticketId: ").append(toIndentedString(ticketId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
