package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 票证数据
 */
@ApiModel(description = "票证数据")

@JsonInclude(NON_NULL)
public class TicketDTO {

    @JsonProperty("id")
    private Long id = null;

    @JsonProperty("ticketCode")
    private String ticketCode = null;

    @JsonProperty("tenantId")
    private Long tenantId = null;

    @JsonProperty("imageId")
    private Long imageId = null;

    @JsonProperty("isPublic")
    private Integer isPublic = null;

    @JsonProperty("billCode")
    private String billCode = null;

    @JsonProperty("batchNo")
    private String batchNo = null;

    @JsonProperty("warningStatus")
    private Integer warningStatus = null;

    @JsonProperty("warningInfo")
    private String warningInfo = null;

    @JsonProperty("exceptionStatus")
    private Integer exceptionStatus = null;

    @JsonProperty("exceptionInfo")
    private String exceptionInfo = null;

    @JsonProperty("checkStatus")
    private Integer checkStatus = null;

    @JsonProperty("checkRemark")
    private String checkRemark = null;

    @JsonProperty("checkTaskId")
    private String checkTaskId = null;

    @JsonProperty("checkRequestTime")
    private Long checkRequestTime = null;

    @JsonProperty("checkResponseTime")
    private Long checkResponseTime = null;

    @JsonProperty("checkUserId")
    private Long checkUserId = null;

    @JsonProperty("checkUserName")
    private String checkUserName = null;

    @JsonProperty("isHooked")
    private Integer isHooked = null;

    @JsonProperty("xPoint")
    private Integer xPoint = null;

    @JsonProperty("yPoint")
    private Integer yPoint = null;

    @JsonProperty("width")
    private Integer width = null;

    @JsonProperty("height")
    private Integer height = null;

    @JsonProperty("angle")
    private Integer angle = null;

    @JsonProperty("createTime")
    private Long createTime = null;

    @JsonProperty("createUserId")
    private Long createUserId = null;

    @JsonProperty("createUserName")
    private String createUserName = null;

    @JsonProperty("updateTime")
    private Long updateTime = null;

    @JsonProperty("updateUserId")
    private Long updateUserId = null;

    @JsonProperty("updateUserName")
    private String updateUserName = null;

    @JsonProperty("amountWithTax")
    private BigDecimal amountWithTax = null;

    @JsonProperty("taxAmount")
    private BigDecimal taxAmount = null;

    @JsonProperty("amountWithoutTax")
    private BigDecimal amountWithoutTax = null;

    @JsonProperty("ticketLabel")
    private String ticketLabel = null;

    @JsonProperty("isReuse")
    private Integer isReuse = null;

    @JsonProperty("extFields")
    private String extFields = null;

    @JsonProperty("ticketStatus")
    private Integer ticketStatus = null;

    @JsonProperty("reserved1")
    private String reserved1 = null;

    @JsonProperty("reserved2")
    private String reserved2 = null;

    @JsonProperty("reserved3")
    private String reserved3 = null;

    @JsonProperty("isRepeat")
    private Integer isRepeat = null;

    @JsonProperty("isAdd")
    private Integer isAdd = null;


    @JsonProperty("isChange")
    private Integer isChange = null;


    @JsonProperty("isReplace")
    private Integer isReplace = null;

    @JsonProperty("checkSignStatus")
    private Integer checkSignStatus = null;

    @JsonProperty("checkSignRemark")
    private String checkSignRemark = null;

    @JsonProperty("checkSignTaskId")
    private String checkSignTaskId = null;

    @JsonProperty("checkSignRequestTime")
    private Long checkSignRequestTime = null;

    @JsonProperty("checkSignUserId")
    private Long checkSignUserId = null;

    @JsonProperty("checkSignUserName")
    private String checkSignUserName = null;

    private BigDecimal usedAmount = null;

    private BigDecimal balanceAmount = null;

    private Integer isOriginalTicket = null;

    private String specialInvoiceFlag = null;

    private Integer commitStatus = null;

    @JsonIgnore
    public TicketDTO id(Long id) {
        this.id = id;
        return this;
    }

    /**
     * 自增主键
     *
     * @return id
     **/
    @ApiModelProperty(value = "自增主键")
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    public TicketDTO ticketCode(String ticketCode) {
        this.ticketCode = ticketCode;
        return this;
    }

    /**
     * 单证code
     *
     * @return ticketCode
     **/
    @ApiModelProperty(value = "单证code")
    public String getTicketCode() {
        return ticketCode;
    }

    public void setTicketCode(String ticketCode) {
        this.ticketCode = ticketCode;
    }

    @JsonIgnore
    public TicketDTO tenantId(Long tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    /**
     * 租户ID
     *
     * @return tenantId
     **/
    @ApiModelProperty(value = "租户ID")
    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    @JsonIgnore
    public TicketDTO imageId(Long imageId) {
        this.imageId = imageId;
        return this;
    }

    /**
     * 影像ID
     *
     * @return imageId
     **/
    @ApiModelProperty(value = "影像ID")
    public Long getImageId() {
        return imageId;
    }

    public void setImageId(Long imageId) {
        this.imageId = imageId;
    }

    @JsonIgnore
    public TicketDTO isPublic(Integer isPublic) {
        this.isPublic = isPublic;
        return this;
    }

    /**
     * 是否公共：0-否，1-是
     *
     * @return isPublic
     **/
    @ApiModelProperty(value = "是否公共：0-否，1-是")
    public Integer getIsPublic() {
        return isPublic;
    }

    public void setIsPublic(Integer isPublic) {
        this.isPublic = isPublic;
    }

    @JsonIgnore
    public TicketDTO billCode(String billCode) {
        this.billCode = billCode;
        return this;
    }

    /**
     * 业务单号
     *
     * @return billCode
     **/
    @ApiModelProperty(value = "业务单号")
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @JsonIgnore
    public TicketDTO batchNo(String batchNo) {
        this.batchNo = batchNo;
        return this;
    }

    /**
     * 扫描批次号
     *
     * @return batchNo
     **/
    @ApiModelProperty(value = "扫描批次号")
    public String getBatchNo() {
        return batchNo;
    }

    public void setBatchNo(String batchNo) {
        this.batchNo = batchNo;
    }

    @JsonIgnore
    public TicketDTO warningStatus(Integer warningStatus) {
        this.warningStatus = warningStatus;
        return this;
    }

    /**
     * 预警状态：0-否，1-是
     *
     * @return warningStatus
     **/
    @ApiModelProperty(value = "预警状态：0-否，1-是")
    public Integer getWarningStatus() {
        return warningStatus;
    }

    public void setWarningStatus(Integer warningStatus) {
        this.warningStatus = warningStatus;
    }

    @JsonIgnore
    public TicketDTO warningInfo(String warningInfo) {
        this.warningInfo = warningInfo;
        return this;
    }

    /**
     * 预警信息
     *
     * @return warningInfo
     **/
    @ApiModelProperty(value = "预警信息")
    public String getWarningInfo() {
        return warningInfo;
    }

    public void setWarningInfo(String warningInfo) {
        this.warningInfo = warningInfo;
    }

    @JsonIgnore
    public TicketDTO exceptionStatus(Integer exceptionStatus) {
        this.exceptionStatus = exceptionStatus;
        return this;
    }

    /**
     * 异常状态：0-否，1-是
     *
     * @return exceptionStatus
     **/
    @ApiModelProperty(value = "异常状态：0-否，1-是")
    public Integer getExceptionStatus() {
        return exceptionStatus;
    }

    public void setExceptionStatus(Integer exceptionStatus) {
        this.exceptionStatus = exceptionStatus;
    }

    @JsonIgnore
    public TicketDTO exceptionInfo(String exceptionInfo) {
        this.exceptionInfo = exceptionInfo;
        return this;
    }

    /**
     * 异常信息
     *
     * @return exceptionInfo
     **/
    @ApiModelProperty(value = "异常信息")
    public String getExceptionInfo() {
        return exceptionInfo;
    }

    public void setExceptionInfo(String exceptionInfo) {
        this.exceptionInfo = exceptionInfo;
    }

    @JsonIgnore
    public TicketDTO checkStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
        return this;
    }

    /**
     * 验真状态：0-待验真，1-验真中，2-验真成功，3-验真失败
     *
     * @return checkStatus
     **/
    @ApiModelProperty(value = "验真状态：0-待验真，1-验真中，2-验真成功，3-验真失败")
    public Integer getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    @JsonIgnore
    public TicketDTO checkRemark(String checkRemark) {
        this.checkRemark = checkRemark;
        return this;
    }

    /**
     * 验真备注
     *
     * @return checkRemark
     **/
    @ApiModelProperty(value = "验真备注")
    public String getCheckRemark() {
        return checkRemark;
    }

    public void setCheckRemark(String checkRemark) {
        this.checkRemark = checkRemark;
    }

    @JsonIgnore
    public TicketDTO checkTaskId(String checkTaskId) {
        this.checkTaskId = checkTaskId;
        return this;
    }

    /**
     * 验真任务ID
     *
     * @return checkTaskId
     **/
    @ApiModelProperty(value = "验真任务ID")
    public String getCheckTaskId() {
        return checkTaskId;
    }

    public void setCheckTaskId(String checkTaskId) {
        this.checkTaskId = checkTaskId;
    }

    @JsonIgnore
    public TicketDTO checkRequestTime(Long checkRequestTime) {
        this.checkRequestTime = checkRequestTime;
        return this;
    }

    /**
     * 验真请求时间
     *
     * @return checkRequestTime
     **/
    @ApiModelProperty(value = "验真请求时间")
    public Long getCheckRequestTime() {
        return checkRequestTime;
    }

    public void setCheckRequestTime(Long checkRequestTime) {
        this.checkRequestTime = checkRequestTime;
    }

    @JsonIgnore
    public TicketDTO checkResponseTime(Long checkResponseTime) {
        this.checkResponseTime = checkResponseTime;
        return this;
    }

    /**
     * 验真返回时间
     *
     * @return checkResponseTime
     **/
    @ApiModelProperty(value = "验真返回时间")
    public Long getCheckResponseTime() {
        return checkResponseTime;
    }

    public void setCheckResponseTime(Long checkResponseTime) {
        this.checkResponseTime = checkResponseTime;
    }

    @JsonIgnore
    public TicketDTO checkUserId(Long checkUserId) {
        this.checkUserId = checkUserId;
        return this;
    }

    /**
     * 验真人ID
     *
     * @return checkUserId
     **/
    @ApiModelProperty(value = "验真人ID")
    public Long getCheckUserId() {
        return checkUserId;
    }

    public void setCheckUserId(Long checkUserId) {
        this.checkUserId = checkUserId;
    }

    @JsonIgnore
    public TicketDTO checkUserName(String checkUserName) {
        this.checkUserName = checkUserName;
        return this;
    }

    /**
     * 验真人姓名
     *
     * @return checkUserName
     **/
    @ApiModelProperty(value = "验真人姓名")
    public String getCheckUserName() {
        return checkUserName;
    }

    public void setCheckUserName(String checkUserName) {
        this.checkUserName = checkUserName;
    }

    @JsonIgnore
    public TicketDTO isHooked(Integer isHooked) {
        this.isHooked = isHooked;
        return this;
    }

    /**
     * 是否已挂接：0-否，1-是
     *
     * @return isHooked
     **/
    @ApiModelProperty(value = "是否已挂接：0-否，1-是")
    public Integer getIsHooked() {
        return isHooked;
    }

    public void setIsHooked(Integer isHooked) {
        this.isHooked = isHooked;
    }

    @JsonIgnore
    public TicketDTO xPoint(Integer xPoint) {
        this.xPoint = xPoint;
        return this;
    }

    /**
     * x点坐标
     *
     * @return xPoint
     **/
    @ApiModelProperty(value = "x点坐标")
    public Integer getXPoint() {
        return xPoint;
    }

    public void setXPoint(Integer xPoint) {
        this.xPoint = xPoint;
    }

    @JsonIgnore
    public TicketDTO yPoint(Integer yPoint) {
        this.yPoint = yPoint;
        return this;
    }

    /**
     * y点坐标
     *
     * @return yPoint
     **/
    @ApiModelProperty(value = "y点坐标")
    public Integer getYPoint() {
        return yPoint;
    }

    public void setYPoint(Integer yPoint) {
        this.yPoint = yPoint;
    }

    @JsonIgnore
    public TicketDTO width(Integer width) {
        this.width = width;
        return this;
    }

    /**
     * 宽度
     *
     * @return width
     **/
    @ApiModelProperty(value = "宽度")
    public Integer getWidth() {
        return width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    @JsonIgnore
    public TicketDTO height(Integer height) {
        this.height = height;
        return this;
    }

    /**
     * 高度
     *
     * @return height
     **/
    @ApiModelProperty(value = "高度")
    public Integer getHeight() {
        return height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    @JsonIgnore
    public TicketDTO angle(Integer angle) {
        this.angle = angle;
        return this;
    }

    /**
     * 方向
     *
     * @return angle
     **/
    @ApiModelProperty(value = "方向")
    public Integer getAngle() {
        return angle;
    }

    public void setAngle(Integer angle) {
        this.angle = angle;
    }

    @JsonIgnore
    public TicketDTO createTime(Long createTime) {
        this.createTime = createTime;
        return this;
    }

    /**
     * 创建时间
     *
     * @return createTime
     **/
    @ApiModelProperty(value = "创建时间")
    public Long getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    @JsonIgnore
    public TicketDTO createUserId(Long createUserId) {
        this.createUserId = createUserId;
        return this;
    }

    /**
     * 创建人ID
     *
     * @return createUserId
     **/
    @ApiModelProperty(value = "创建人ID")
    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    @JsonIgnore
    public TicketDTO createUserName(String createUserName) {
        this.createUserName = createUserName;
        return this;
    }

    /**
     * 创建人姓名
     *
     * @return createUserName
     **/
    @ApiModelProperty(value = "创建人姓名")
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    @JsonIgnore
    public TicketDTO updateTime(Long updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    /**
     * 更新时间
     *
     * @return updateTime
     **/
    @ApiModelProperty(value = "更新时间")
    public Long getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
    }

    @JsonIgnore
    public TicketDTO updateUserId(Long updateUserId) {
        this.updateUserId = updateUserId;
        return this;
    }

    /**
     * 更新人ID
     *
     * @return updateUserId
     **/
    @ApiModelProperty(value = "更新人ID")
    public Long getUpdateUserId() {
        return updateUserId;
    }

    public void setUpdateUserId(Long updateUserId) {
        this.updateUserId = updateUserId;
    }

    @JsonIgnore
    public TicketDTO updateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
        return this;
    }

    /**
     * 更新人姓名
     *
     * @return updateUserName
     **/
    @ApiModelProperty(value = "更新人姓名")
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    @JsonIgnore
    public TicketDTO amountWithTax(BigDecimal amountWithTax) {
        this.amountWithTax = amountWithTax;
        return this;
    }

    /**
     * 含税金额
     *
     * @return amountWithTax
     **/
    @ApiModelProperty(value = "含税金额")
    public BigDecimal getAmountWithTax() {
        return amountWithTax;
    }

    public void setAmountWithTax(BigDecimal amountWithTax) {
        this.amountWithTax = amountWithTax;
    }

    @JsonIgnore
    public TicketDTO taxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
        return this;
    }

    /**
     * 税额
     *
     * @return taxAmount
     **/
    @ApiModelProperty(value = "税额")
    public BigDecimal getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    @JsonIgnore
    public TicketDTO amountWithoutTax(BigDecimal amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
        return this;
    }

    /**
     * 不含税金额
     *
     * @return amountWithoutTax
     **/
    @ApiModelProperty(value = "不含税金额")
    public BigDecimal getAmountWithoutTax() {
        return amountWithoutTax;
    }

    public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
    }

    @JsonIgnore
    public TicketDTO ticketLabel(String ticketLabel) {
        this.ticketLabel = ticketLabel;
        return this;
    }

    /**
     * 标签
     *
     * @return ticketLabel
     **/
    @ApiModelProperty(value = "标签")
    public String getTicketLabel() {
        return ticketLabel;
    }

    public void setTicketLabel(String ticketLabel) {
        this.ticketLabel = ticketLabel;
    }

    @JsonIgnore
    public TicketDTO isReuse(Integer isReuse) {
        this.isReuse = isReuse;
        return this;
    }

    /**
     * 是否复用:0-否,1-是
     *
     * @return isReuse
     **/
    @ApiModelProperty(value = "是否复用:0-否,1-是")
    public Integer getIsReuse() {
        return isReuse;
    }

    public void setIsReuse(Integer isReuse) {
        this.isReuse = isReuse;
    }

    @JsonIgnore
    public TicketDTO extFields(String extFields) {
        this.extFields = extFields;
        return this;
    }

    /**
     * 扩展字段
     *
     * @return extFields
     **/
    @ApiModelProperty(value = "扩展字段")
    public String getExtFields() {
        return extFields;
    }

    public void setExtFields(String extFields) {
        this.extFields = extFields;
    }

    @JsonIgnore
    public TicketDTO ticketStatus(Integer ticketStatus) {
        this.ticketStatus = ticketStatus;
        return this;
    }

    /**
     * 单证状态:0-未锁定,1-已锁定,2-已完成
     *
     * @return ticketStatus
     **/
    @ApiModelProperty(value = "单证状态:0-未锁定,1-已锁定,2-已完成")
    public Integer getTicketStatus() {
        return ticketStatus;
    }

    public void setTicketStatus(Integer ticketStatus) {
        this.ticketStatus = ticketStatus;
    }

    @JsonIgnore
    public TicketDTO reserved1(String reserved1) {
        this.reserved1 = reserved1;
        return this;
    }

    /**
     * 保留字段1
     *
     * @return reserved1
     **/
    @ApiModelProperty(value = "保留字段1")
    public String getReserved1() {
        return reserved1;
    }

    public void setReserved1(String reserved1) {
        this.reserved1 = reserved1;
    }

    @JsonIgnore
    public TicketDTO reserved2(String reserved2) {
        this.reserved2 = reserved2;
        return this;
    }

    /**
     * 保留字段2
     *
     * @return reserved2
     **/
    @ApiModelProperty(value = "保留字段2")
    public String getReserved2() {
        return reserved2;
    }

    public void setReserved2(String reserved2) {
        this.reserved2 = reserved2;
    }

    @JsonIgnore
    public TicketDTO reserved3(String reserved3) {
        this.reserved3 = reserved3;
        return this;
    }

    /**
     * 保留字段3
     *
     * @return reserved3
     **/
    @ApiModelProperty(value = "保留字段3")
    public String getReserved3() {
        return reserved3;
    }

    public void setReserved3(String reserved3) {
        this.reserved3 = reserved3;
    }

    @JsonIgnore
    public TicketDTO isRepeat(Integer isRepeat) {
        this.isRepeat = isRepeat;
        return this;
    }

    /**
     * 是否重复:0-否,1-是
     *
     * @return isRepeat
     **/
    @ApiModelProperty(value = "是否重复:0-否,1-是")
    public Integer getIsRepeat() {
        return isRepeat;
    }

    public void setIsRepeat(Integer isRepeat) {
        this.isRepeat = isRepeat;
    }

    public Integer getxPoint() {
        return xPoint;
    }

    public void setxPoint(Integer xPoint) {
        this.xPoint = xPoint;
    }

    public Integer getyPoint() {
        return yPoint;
    }

    public void setyPoint(Integer yPoint) {
        this.yPoint = yPoint;
    }

    public Integer getIsAdd() {
        return isAdd;
    }

    public void setIsAdd(Integer isAdd) {
        this.isAdd = isAdd;
    }

    public Integer getIsChange() {
        return isChange;
    }

    public void setIsChange(Integer isChange) {
        this.isChange = isChange;
    }

    public Integer getIsReplace() {
        return isReplace;
    }

    public void setIsReplace(Integer isReplace) {
        this.isReplace = isReplace;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TicketDTO ticketDTO = (TicketDTO) o;
        return Objects.equals(this.id, ticketDTO.id) &&
            Objects.equals(this.ticketCode, ticketDTO.ticketCode) &&
            Objects.equals(this.tenantId, ticketDTO.tenantId) &&
            Objects.equals(this.imageId, ticketDTO.imageId) &&
            Objects.equals(this.isPublic, ticketDTO.isPublic) &&
            Objects.equals(this.billCode, ticketDTO.billCode) &&
            Objects.equals(this.batchNo, ticketDTO.batchNo) &&
            Objects.equals(this.warningStatus, ticketDTO.warningStatus) &&
            Objects.equals(this.warningInfo, ticketDTO.warningInfo) &&
            Objects.equals(this.exceptionStatus, ticketDTO.exceptionStatus) &&
            Objects.equals(this.exceptionInfo, ticketDTO.exceptionInfo) &&
            Objects.equals(this.checkStatus, ticketDTO.checkStatus) &&
            Objects.equals(this.checkRemark, ticketDTO.checkRemark) &&
            Objects.equals(this.checkTaskId, ticketDTO.checkTaskId) &&
            Objects.equals(this.checkRequestTime, ticketDTO.checkRequestTime) &&
            Objects.equals(this.checkResponseTime, ticketDTO.checkResponseTime) &&
            Objects.equals(this.checkUserId, ticketDTO.checkUserId) &&
            Objects.equals(this.checkUserName, ticketDTO.checkUserName) &&
            Objects.equals(this.isHooked, ticketDTO.isHooked) &&
            Objects.equals(this.xPoint, ticketDTO.xPoint) &&
            Objects.equals(this.yPoint, ticketDTO.yPoint) &&
            Objects.equals(this.width, ticketDTO.width) &&
            Objects.equals(this.height, ticketDTO.height) &&
            Objects.equals(this.angle, ticketDTO.angle) &&
            Objects.equals(this.createTime, ticketDTO.createTime) &&
            Objects.equals(this.createUserId, ticketDTO.createUserId) &&
            Objects.equals(this.createUserName, ticketDTO.createUserName) &&
            Objects.equals(this.updateTime, ticketDTO.updateTime) &&
            Objects.equals(this.updateUserId, ticketDTO.updateUserId) &&
            Objects.equals(this.updateUserName, ticketDTO.updateUserName) &&
            Objects.equals(this.amountWithTax, ticketDTO.amountWithTax) &&
            Objects.equals(this.taxAmount, ticketDTO.taxAmount) &&
            Objects.equals(this.amountWithoutTax, ticketDTO.amountWithoutTax) &&
            Objects.equals(this.ticketLabel, ticketDTO.ticketLabel) &&
            Objects.equals(this.isReuse, ticketDTO.isReuse) &&
            Objects.equals(this.extFields, ticketDTO.extFields) &&
            Objects.equals(this.ticketStatus, ticketDTO.ticketStatus) &&
            Objects.equals(this.reserved1, ticketDTO.reserved1) &&
            Objects.equals(this.reserved2, ticketDTO.reserved2) &&
            Objects.equals(this.reserved3, ticketDTO.reserved3) &&
            Objects.equals(this.isRepeat, ticketDTO.isRepeat) &&
            Objects.equals(this.reserved3, ticketDTO.isAdd) &&
            Objects.equals(this.reserved3, ticketDTO.isChange) &&
            Objects.equals(this.reserved3, ticketDTO.isReplace);
    }

    @Override
    public int hashCode() {
        return Objects
            .hash(id, ticketCode, tenantId, imageId, isPublic, billCode, batchNo, warningStatus, warningInfo, exceptionStatus, exceptionInfo, checkStatus, checkRemark, checkTaskId, checkRequestTime,
                checkResponseTime, checkUserId, checkUserName, isHooked, xPoint, yPoint, width, height, angle, createTime, createUserId, createUserName, updateTime, updateUserId, updateUserName,
                amountWithTax, taxAmount, amountWithoutTax, ticketLabel, isReuse, extFields, ticketStatus, reserved1, reserved2, reserved3, isRepeat, isAdd, isChange, isReplace);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TicketDTO {\n");

        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    ticketCode: ").append(toIndentedString(ticketCode)).append("\n");
        sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
        sb.append("    imageId: ").append(toIndentedString(imageId)).append("\n");
        sb.append("    isPublic: ").append(toIndentedString(isPublic)).append("\n");
        sb.append("    billCode: ").append(toIndentedString(billCode)).append("\n");
        sb.append("    batchNo: ").append(toIndentedString(batchNo)).append("\n");
        sb.append("    warningStatus: ").append(toIndentedString(warningStatus)).append("\n");
        sb.append("    warningInfo: ").append(toIndentedString(warningInfo)).append("\n");
        sb.append("    exceptionStatus: ").append(toIndentedString(exceptionStatus)).append("\n");
        sb.append("    exceptionInfo: ").append(toIndentedString(exceptionInfo)).append("\n");
        sb.append("    checkStatus: ").append(toIndentedString(checkStatus)).append("\n");
        sb.append("    checkRemark: ").append(toIndentedString(checkRemark)).append("\n");
        sb.append("    checkTaskId: ").append(toIndentedString(checkTaskId)).append("\n");
        sb.append("    checkRequestTime: ").append(toIndentedString(checkRequestTime)).append("\n");
        sb.append("    checkResponseTime: ").append(toIndentedString(checkResponseTime)).append("\n");
        sb.append("    checkUserId: ").append(toIndentedString(checkUserId)).append("\n");
        sb.append("    checkUserName: ").append(toIndentedString(checkUserName)).append("\n");
        sb.append("    isHooked: ").append(toIndentedString(isHooked)).append("\n");
        sb.append("    xPoint: ").append(toIndentedString(xPoint)).append("\n");
        sb.append("    yPoint: ").append(toIndentedString(yPoint)).append("\n");
        sb.append("    width: ").append(toIndentedString(width)).append("\n");
        sb.append("    height: ").append(toIndentedString(height)).append("\n");
        sb.append("    angle: ").append(toIndentedString(angle)).append("\n");
        sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
        sb.append("    createUserId: ").append(toIndentedString(createUserId)).append("\n");
        sb.append("    createUserName: ").append(toIndentedString(createUserName)).append("\n");
        sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
        sb.append("    updateUserId: ").append(toIndentedString(updateUserId)).append("\n");
        sb.append("    updateUserName: ").append(toIndentedString(updateUserName)).append("\n");
        sb.append("    amountWithTax: ").append(toIndentedString(amountWithTax)).append("\n");
        sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
        sb.append("    amountWithoutTax: ").append(toIndentedString(amountWithoutTax)).append("\n");
        sb.append("    ticketLabel: ").append(toIndentedString(ticketLabel)).append("\n");
        sb.append("    isReuse: ").append(toIndentedString(isReuse)).append("\n");
        sb.append("    extFields: ").append(toIndentedString(extFields)).append("\n");
        sb.append("    ticketStatus: ").append(toIndentedString(ticketStatus)).append("\n");
        sb.append("    reserved1: ").append(toIndentedString(reserved1)).append("\n");
        sb.append("    reserved2: ").append(toIndentedString(reserved2)).append("\n");
        sb.append("    reserved3: ").append(toIndentedString(reserved3)).append("\n");
        sb.append("    isRepeat: ").append(toIndentedString(isRepeat)).append("\n");
        sb.append("    isAdd: ").append(toIndentedString(isAdd)).append("\n");
        sb.append("    isChange: ").append(toIndentedString(isChange)).append("\n");
        sb.append("    isReplace: ").append(toIndentedString(isReplace)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public Integer getCheckSignStatus() {
        return checkSignStatus;
    }

    public void setCheckSignStatus(Integer checkSignStatus) {
        this.checkSignStatus = checkSignStatus;
    }

    public String getCheckSignRemark() {
        return checkSignRemark;
    }

    public void setCheckSignRemark(String checkSignRemark) {
        this.checkSignRemark = checkSignRemark;
    }

    public String getCheckSignTaskId() {
        return checkSignTaskId;
    }

    public void setCheckSignTaskId(String checkSignTaskId) {
        this.checkSignTaskId = checkSignTaskId;
    }

    public Long getCheckSignRequestTime() {
        return checkSignRequestTime;
    }

    public void setCheckSignRequestTime(Long checkSignRequestTime) {
        this.checkSignRequestTime = checkSignRequestTime;
    }

    public Long getCheckSignUserId() {
        return checkSignUserId;
    }

    public void setCheckSignUserId(Long checkSignUserId) {
        this.checkSignUserId = checkSignUserId;
    }

    public String getCheckSignUserName() {
        return checkSignUserName;
    }

    public void setCheckSignUserName(String checkSignUserName) {
        this.checkSignUserName = checkSignUserName;
    }

    public BigDecimal getUsedAmount() {
        return usedAmount;
    }

    public void setUsedAmount(BigDecimal usedAmount) {
        this.usedAmount = usedAmount;
    }

    public BigDecimal getBalanceAmount() {
        return balanceAmount;
    }

    public void setBalanceAmount(BigDecimal balanceAmount) {
        this.balanceAmount = balanceAmount;
    }

    public Integer getIsOriginalTicket() {
        return isOriginalTicket;
    }

    public void setIsOriginalTicket(Integer isOriginalTicket) {
        this.isOriginalTicket = isOriginalTicket;
    }

    public String getSpecialInvoiceFlag() {
        return specialInvoiceFlag;
    }

    public void setSpecialInvoiceFlag(String specialInvoiceFlag) {
        this.specialInvoiceFlag = specialInvoiceFlag;
    }

    public Integer getCommitStatus() {
        return commitStatus;
    }

    public void setCommitStatus(Integer commitStatus) {
        this.commitStatus = commitStatus;
    }

}
