package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 影像表Request
 */
@ApiModel(description = "影像表Request")

@JsonInclude(NON_NULL)
public class UpdateImageCopyRequest extends BaseRequest {

    @JsonProperty("entities")
    private List<ImageCopyDTO> entities = new ArrayList<ImageCopyDTO>();

    @JsonIgnore
    public UpdateImageCopyRequest entities(List<ImageCopyDTO> entities) {
        this.entities = entities;
        return this;
    }

    public UpdateImageCopyRequest addEntitiesItem(ImageCopyDTO entitiesItem) {
        this.entities.add(entitiesItem);
        return this;
    }

    /**
     * Get entities
     *
     * @return entities
     **/
    @ApiModelProperty(value = "")
    public List<ImageCopyDTO> getEntities() {
        return entities;
    }

    public void setEntities(List<ImageCopyDTO> entities) {
        this.entities = entities;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateImageCopyRequest updateImageCopyRequest = (UpdateImageCopyRequest) o;
        return Objects.equals(this.entities, updateImageCopyRequest.entities) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(entities, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateImageCopyRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    entities: ").append(toIndentedString(entities)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
