package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 物流Request
 */
@ApiModel(description = "物流Request")

@JsonInclude(NON_NULL)
public class UpdateLogisticsPostcodeRequest extends BaseRequest {

    @JsonProperty("entities")
    private List<LogisticsPostcodeDTO> entities = new ArrayList<LogisticsPostcodeDTO>();

    @JsonIgnore
    public UpdateLogisticsPostcodeRequest entities(List<LogisticsPostcodeDTO> entities) {
        this.entities = entities;
        return this;
    }

    public UpdateLogisticsPostcodeRequest addEntitiesItem(LogisticsPostcodeDTO entitiesItem) {
        this.entities.add(entitiesItem);
        return this;
    }

    /**
     * Get entities
     *
     * @return entities
     **/
    @ApiModelProperty(value = "")
    public List<LogisticsPostcodeDTO> getEntities() {
        return entities;
    }

    public void setEntities(List<LogisticsPostcodeDTO> entities) {
        this.entities = entities;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateLogisticsPostcodeRequest updateLogisticsPostcodeRequest = (UpdateLogisticsPostcodeRequest) o;
        return Objects.equals(this.entities, updateLogisticsPostcodeRequest.entities) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(entities, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateLogisticsPostcodeRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    entities: ").append(toIndentedString(entities)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
