package com.xforceplus.elephant.image.client.api;

import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;


@Api(value = "businessLog", description = "the businessLog API", tags = "businessLog")
public interface BusinessLogApi {

    @ApiOperation(value = "查询业务日志", notes = "查询业务日志", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/businessLog/get",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getBusinessLog(@ApiParam(value = "主键", required = true) @RequestParam("businessId") Long businessId
    );

}
