package com.xforceplus.elephant.image.client.api;

import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import com.xforceplus.elephant.image.client.model.GetLogMqListRequest;
import com.xforceplus.elephant.image.client.model.HandleMessageRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


@Api(value = "logMq", description = "the logMq API", tags = "logMq")
public interface LogMqApi {

    @ApiOperation(value = "删除消息", notes = "删除消息", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "数据列表")})
    @RequestMapping(value = "/logMq/deleteMessage",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse deleteMessage(@ApiParam(value = "request", required = true) @Valid HandleMessageRequest request
    );


    @ApiOperation(value = "获取死信队列消息", notes = "获取死信队列消息", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "数据列表")})
    @RequestMapping(value = "/logMq/getDeadLetterMessageList",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getDeadLetterMessageList(@ApiParam(value = "request", required = true) @Valid BaseRequest request
    );


    @ApiOperation(value = "获取详情", notes = "", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/logMq/{mqId}",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getLogMqDetail(@ApiParam(value = "", required = true) @PathVariable("mqId") Long mqId
        , @ApiParam(value = "request", required = true) @Valid BaseRequest request
    );


    @ApiOperation(value = "获取列表", notes = "获取数据", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "数据列表")})
    @RequestMapping(value = "/logMq",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getLogMqList(@ApiParam(value = "request", required = true) @Valid GetLogMqListRequest request
    );


    @ApiOperation(value = "处理消息", notes = "处理消息", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "数据列表")})
    @RequestMapping(value = "/logMq/handleMessage",
        produces = {"application/json"},
        method = RequestMethod.POST)
    CommonResponse handleMessage(@ApiParam(value = "request", required = true) @Valid HandleMessageRequest request
    );

}
