package com.xforceplus.elephant.image.client.api;

import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


@Api(value = "receiveFiles", description = "the receiveFiles API", tags = "receiveFiles")
public interface ReceiveFilesApi {

    @ApiOperation(value = "获取第三方文件接收数据流", notes = "", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/receiveFiles/{id:[0-9]+}.{fileExt}",
        produces = {"application/octet-stream"},
        method = RequestMethod.GET)
    Object download(@ApiParam(value = "自增主键", required = true) @PathVariable("id") Long id
        , @ApiParam(value = "文件类型", required = true) @PathVariable("fileExt") String fileExt
        , @ApiParam(value = "request", required = true) @Valid BaseRequest request
    );

}
