package com.xforceplus.elephant.image.client.api;

import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import com.xforceplus.elephant.basecommon.process.response.CommonResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


@Api(value = "scanTodo", description = "the scanTodo API", tags = "scanTodo")
public interface ScanTodoApi {

    @ApiOperation(value = "获取单据数量", notes = "获取单据数量", authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "response")})
    @RequestMapping(value = "/scanTodo/countTodoInfo",
        produces = {"application/json"},
        method = RequestMethod.GET)
    CommonResponse getCountTodoInfo(@ApiParam(value = "request", required = true) @Valid BaseRequest request
    );

}
