package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 单据退回接口
 */
@ApiModel(description = "单据退回接口")

@JsonInclude(NON_NULL)
public class BackBaseBillRequest extends BaseRequest {

    @JsonProperty("billCodes")
    private List<String> billCodes = new ArrayList<String>();

    @JsonProperty("backReason")
    private Integer backReason = null;

    @JsonProperty("backRemark")
    private String backRemark = null;

    @JsonIgnore
    public BackBaseBillRequest billCodes(List<String> billCodes) {
        this.billCodes = billCodes;
        return this;
    }

    public BackBaseBillRequest addBillCodesItem(String billCodesItem) {
        this.billCodes.add(billCodesItem);
        return this;
    }

    /**
     * 单据code集合
     *
     * @return billCodes
     **/
    @ApiModelProperty(value = "单据code集合")
    public List<String> getBillCodes() {
        return billCodes;
    }

    public void setBillCodes(List<String> billCodes) {
        this.billCodes = billCodes;
    }

    @JsonIgnore
    public BackBaseBillRequest backReason(Integer backReason) {
        this.backReason = backReason;
        return this;
    }

    /**
     * 退回类型
     *
     * @return backReason
     **/
    @ApiModelProperty(value = "退回类型")
    public Integer getBackReason() {
        return backReason;
    }

    public void setBackReason(Integer backReason) {
        this.backReason = backReason;
    }

    @JsonIgnore
    public BackBaseBillRequest backRemark(String backRemark) {
        this.backRemark = backRemark;
        return this;
    }

    /**
     * 退回原因
     *
     * @return backRemark
     **/
    @ApiModelProperty(value = "退回原因")
    public String getBackRemark() {
        return backRemark;
    }

    public void setBackRemark(String backRemark) {
        this.backRemark = backRemark;
    }


    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BackBaseBillRequest backBaseBillRequest = (BackBaseBillRequest) o;
        return Objects.equals(this.billCodes, backBaseBillRequest.billCodes) &&
            Objects.equals(this.backReason, backBaseBillRequest.backReason) &&
            Objects.equals(this.backRemark, backBaseBillRequest.backRemark) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(billCodes, backReason, backRemark, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BackBaseBillRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    billCodes: ").append(toIndentedString(billCodes)).append("\n");
        sb.append("    backReason: ").append(toIndentedString(backReason)).append("\n");
        sb.append("    backRemark: ").append(toIndentedString(backRemark)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
