package com.xforceplus.elephant.image.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.elephant.basecommon.process.request.BaseRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 回退稽核单据
 */
@ApiModel(description = "回退稽核单据")

@JsonInclude(NON_NULL)
public class BackCompareBillRequest extends BaseRequest {

    @JsonProperty("billCodes")
    private List<String> billCodes = new ArrayList<String>();

    @JsonIgnore
    public BackCompareBillRequest billCodes(List<String> billCodes) {
        this.billCodes = billCodes;
        return this;
    }

    public BackCompareBillRequest addBillCodesItem(String billCodesItem) {
        this.billCodes.add(billCodesItem);
        return this;
    }

    /**
     * 单据code集合
     *
     * @return billCodes
     **/
    @ApiModelProperty(value = "单据code集合")
    public List<String> getBillCodes() {
        return billCodes;
    }

    public void setBillCodes(List<String> billCodes) {
        this.billCodes = billCodes;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BackCompareBillRequest baseBillDeleteRequest = (BackCompareBillRequest) o;
        return Objects.equals(this.billCodes, baseBillDeleteRequest.billCodes) &&
            super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(billCodes, super.hashCode());
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BaseBillDeleteRequest {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    billCodes: ").append(toIndentedString(billCodes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
